package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitOpsClusterListFluent<A extends GitOpsClusterListFluent<A>> extends BaseFluent<A>{
  public GitOpsClusterListFluent() {
  }
  public GitOpsClusterListFluent(GitOpsClusterList instance) {
    instance = (instance != null ? instance : new GitOpsClusterList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<GitOpsClusterBuilder> items = new ArrayList<GitOpsClusterBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,GitOpsCluster item) {
    if (this.items == null) {this.items = new ArrayList<GitOpsClusterBuilder>();}
    GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,GitOpsCluster item) {
    if (this.items == null) {this.items = new ArrayList<GitOpsClusterBuilder>();}
    GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.GitOpsCluster... items) {
    if (this.items == null) {this.items = new ArrayList<GitOpsClusterBuilder>();}
    for (GitOpsCluster item : items) {GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<GitOpsCluster> items) {
    if (this.items == null) {this.items = new ArrayList<GitOpsClusterBuilder>();}
    for (GitOpsCluster item : items) {GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.GitOpsCluster... items) {
    if (this.items == null) return (A)this;
    for (GitOpsCluster item : items) {GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  public A removeAllFromItems(Collection<GitOpsCluster> items) {
    if (this.items == null) return (A)this;
    for (GitOpsCluster item : items) {GitOpsClusterBuilder builder = new GitOpsClusterBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<GitOpsClusterBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<GitOpsClusterBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      GitOpsClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GitOpsCluster> buildItems() {
    return items != null ? build(items) : null;
  }
  public GitOpsCluster buildItem(int index) {
    return this.items.get(index).build();
  }
  public GitOpsCluster buildFirstItem() {
    return this.items.get(0).build();
  }
  public GitOpsCluster buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public GitOpsCluster buildMatchingItem(Predicate<GitOpsClusterBuilder> predicate) {
    for (GitOpsClusterBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingItem(Predicate<GitOpsClusterBuilder> predicate) {
    for (GitOpsClusterBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<GitOpsCluster> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (GitOpsCluster item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.GitOpsCluster... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (GitOpsCluster item :items){ this.addToItems(item);}} return (A) this;
  }
  public boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  public ItemsNested<A> addNewItemLike(GitOpsCluster item) {
    return new ItemsNested(-1, item);
  }
  public ItemsNested<A> setNewItemLike(int index,GitOpsCluster item) {
    return new ItemsNested(index, item);
  }
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public ItemsNested<A> editMatchingItem(Predicate<GitOpsClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitOpsClusterListFluent that = (GitOpsClusterListFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  public class ItemsNested<N> extends GitOpsClusterFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,GitOpsCluster item) {
      this.index = index;
      this.builder = new GitOpsClusterBuilder(this, item);
    }
    GitOpsClusterBuilder builder;
    int index;
    public N and() {
      return (N) GitOpsClusterListFluent.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}