package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ArgoServerSpecBuilder extends ArgoServerSpecFluent<ArgoServerSpecBuilder> implements VisitableBuilder<ArgoServerSpec,ArgoServerSpecBuilder>{
  public ArgoServerSpecBuilder() {
    this(false);
  }
  public ArgoServerSpecBuilder(Boolean validationEnabled) {
    this(new ArgoServerSpec(), validationEnabled);
  }
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ArgoServerSpec(), validationEnabled);
  }
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent,ArgoServerSpec instance) {
    this(fluent, instance, false);
  }
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent,ArgoServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ArgoServerSpec());

    if (instance != null) {
      fluent.withArgoNamespace(instance.getArgoNamespace());
      fluent.withCluster(instance.getCluster());
      fluent.withArgoNamespace(instance.getArgoNamespace());
      fluent.withCluster(instance.getCluster());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ArgoServerSpecBuilder(ArgoServerSpec instance) {
    this(instance,false);
  }
  public ArgoServerSpecBuilder(ArgoServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ArgoServerSpec());

    if (instance != null) {
      this.withArgoNamespace(instance.getArgoNamespace());
      this.withCluster(instance.getCluster());
      this.withArgoNamespace(instance.getArgoNamespace());
      this.withCluster(instance.getCluster());
    }
    this.validationEnabled = validationEnabled; 
  }
  ArgoServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ArgoServerSpec build() {
    ArgoServerSpec buildable = new ArgoServerSpec(fluent.getArgoNamespace(),fluent.getCluster());
    return buildable;
  }
  
}