/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterClaimSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterClaimSelectorFluent<A extends ClusterClaimSelectorFluent<A>>
extends BaseFluent<A> {
    private List<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();

    public ClusterClaimSelectorFluent() {
    }

    public ClusterClaimSelectorFluent(ClusterClaimSelector instance) {
        ClusterClaimSelector clusterClaimSelector = instance = instance != null ? instance : new ClusterClaimSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchExpressions(instance.getMatchExpressions());
        }
    }

    public A addToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.add(index, item);
        return (A)((Object)this);
    }

    public A setToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.set(index, item);
        return (A)((Object)this);
    }

    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    public LabelSelectorRequirement getMatchExpression(int index) {
        return this.matchExpressions.get(index);
    }

    public LabelSelectorRequirement getFirstMatchExpression() {
        return this.matchExpressions.get(0);
    }

    public LabelSelectorRequirement getLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1);
    }

    public LabelSelectorRequirement getMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove((Object)"matchExpressions");
        }
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterClaimSelectorFluent that = (ClusterClaimSelectorFluent)((Object)o);
        return Objects.equals(this.matchExpressions, that.matchExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions);
        }
        sb.append("}");
        return sb.toString();
    }
}

