package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSetStatusBuilder extends ManagedClusterSetStatusFluent<ManagedClusterSetStatusBuilder> implements VisitableBuilder<ManagedClusterSetStatus,ManagedClusterSetStatusBuilder>{
  public ManagedClusterSetStatusBuilder() {
    this(false);
  }
  public ManagedClusterSetStatusBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSetStatus(), validationEnabled);
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSetStatus(), validationEnabled);
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatusFluent<?> fluent,ManagedClusterSetStatus instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatusFluent<?> fluent,ManagedClusterSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedClusterSetStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatus instance) {
    this(instance,false);
  }
  public ManagedClusterSetStatusBuilder(ManagedClusterSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedClusterSetStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSetStatus build() {
    ManagedClusterSetStatus buildable = new ManagedClusterSetStatus(fluent.getConditions());
    return buildable;
  }
  
}