package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSetBindingSpecBuilder extends ManagedClusterSetBindingSpecFluent<ManagedClusterSetBindingSpecBuilder> implements VisitableBuilder<ManagedClusterSetBindingSpec,ManagedClusterSetBindingSpecBuilder>{
  public ManagedClusterSetBindingSpecBuilder() {
    this(false);
  }
  public ManagedClusterSetBindingSpecBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSetBindingSpec(), validationEnabled);
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSetBindingSpec(), validationEnabled);
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpecFluent<?> fluent,ManagedClusterSetBindingSpec instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpecFluent<?> fluent,ManagedClusterSetBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedClusterSetBindingSpec());

    if (instance != null) {
      fluent.withClusterSet(instance.getClusterSet());
      fluent.withClusterSet(instance.getClusterSet());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpec instance) {
    this(instance,false);
  }
  public ManagedClusterSetBindingSpecBuilder(ManagedClusterSetBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedClusterSetBindingSpec());

    if (instance != null) {
      this.withClusterSet(instance.getClusterSet());
      this.withClusterSet(instance.getClusterSet());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSetBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSetBindingSpec build() {
    ManagedClusterSetBindingSpec buildable = new ManagedClusterSetBindingSpec(fluent.getClusterSet());
    return buildable;
  }
  
}