package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementSpecFluent<A extends PlacementSpecFluent<A>> extends BaseFluent<A>{
  public PlacementSpecFluent() {
  }
  public PlacementSpecFluent(PlacementSpec instance) {
    instance = (instance != null ? instance : new PlacementSpec());

    if (instance != null) {
      this.withClusterSets(instance.getClusterSets());
      this.withNumberOfClusters(instance.getNumberOfClusters());
      this.withPredicates(instance.getPredicates());
      this.withPrioritizerPolicy(instance.getPrioritizerPolicy());
      this.withClusterSets(instance.getClusterSets());
      this.withNumberOfClusters(instance.getNumberOfClusters());
      this.withPredicates(instance.getPredicates());
      this.withPrioritizerPolicy(instance.getPrioritizerPolicy());
    }
  }
  private List<String> clusterSets = new ArrayList<String>();
  private Integer numberOfClusters;
  private ArrayList<ClusterPredicateBuilder> predicates = new ArrayList<ClusterPredicateBuilder>();
  private PrioritizerPolicyBuilder prioritizerPolicy;
  public A addToClusterSets(int index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.add(index, item);
    return (A)this;
  }
  public A setToClusterSets(int index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.set(index, item); return (A)this;
  }
  public A addToClusterSets(java.lang.String... items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  public A addAllToClusterSets(Collection<String> items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  public A removeFromClusterSets(java.lang.String... items) {
    if (this.clusterSets == null) return (A)this;
    for (String item : items) { this.clusterSets.remove(item);} return (A)this;
  }
  public A removeAllFromClusterSets(Collection<String> items) {
    if (this.clusterSets == null) return (A)this;
    for (String item : items) { this.clusterSets.remove(item);} return (A)this;
  }
  public List<String> getClusterSets() {
    return this.clusterSets;
  }
  public String getClusterSet(int index) {
    return this.clusterSets.get(index);
  }
  public String getFirstClusterSet() {
    return this.clusterSets.get(0);
  }
  public String getLastClusterSet() {
    return this.clusterSets.get(clusterSets.size() - 1);
  }
  public String getMatchingClusterSet(Predicate<String> predicate) {
    for (String item: clusterSets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingClusterSet(Predicate<String> predicate) {
    for (String item: clusterSets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterSets(List<String> clusterSets) {
    if (clusterSets != null) {this.clusterSets = new ArrayList(); for (String item : clusterSets){this.addToClusterSets(item);}} else { this.clusterSets = null;} return (A) this;
  }
  public A withClusterSets(java.lang.String... clusterSets) {
    if (this.clusterSets != null) {this.clusterSets.clear(); _visitables.remove("clusterSets"); }
    if (clusterSets != null) {for (String item :clusterSets){ this.addToClusterSets(item);}} return (A) this;
  }
  public boolean hasClusterSets() {
    return clusterSets != null && !clusterSets.isEmpty();
  }
  public Integer getNumberOfClusters() {
    return this.numberOfClusters;
  }
  public A withNumberOfClusters(Integer numberOfClusters) {
    this.numberOfClusters=numberOfClusters; return (A) this;
  }
  public boolean hasNumberOfClusters() {
    return this.numberOfClusters != null;
  }
  public A addToPredicates(int index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
    if (index < 0 || index >= predicates.size()) { _visitables.get("predicates").add(builder); predicates.add(builder); } else { _visitables.get("predicates").add(index, builder); predicates.add(index, builder);}
    return (A)this;
  }
  public A setToPredicates(int index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
    if (index < 0 || index >= predicates.size()) { _visitables.get("predicates").add(builder); predicates.add(builder); } else { _visitables.get("predicates").set(index, builder); predicates.set(index, builder);}
    return (A)this;
  }
  public A addToPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  public A addAllToPredicates(Collection<ClusterPredicate> items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  public A removeFromPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... items) {
    if (this.predicates == null) return (A)this;
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder); this.predicates.remove(builder);} return (A)this;
  }
  public A removeAllFromPredicates(Collection<ClusterPredicate> items) {
    if (this.predicates == null) return (A)this;
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder); this.predicates.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPredicates(Predicate<ClusterPredicateBuilder> predicate) {
    if (predicates == null) return (A) this;
    final Iterator<ClusterPredicateBuilder> each = predicates.iterator();
    final List visitables = _visitables.get("predicates");
    while (each.hasNext()) {
      ClusterPredicateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ClusterPredicate> buildPredicates() {
    return predicates != null ? build(predicates) : null;
  }
  public ClusterPredicate buildPredicate(int index) {
    return this.predicates.get(index).build();
  }
  public ClusterPredicate buildFirstPredicate() {
    return this.predicates.get(0).build();
  }
  public ClusterPredicate buildLastPredicate() {
    return this.predicates.get(predicates.size() - 1).build();
  }
  public ClusterPredicate buildMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    for (ClusterPredicateBuilder item: predicates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    for (ClusterPredicateBuilder item: predicates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPredicates(List<ClusterPredicate> predicates) {
    if (this.predicates != null) { _visitables.get("predicates").clear();}
    if (predicates != null) {this.predicates = new ArrayList(); for (ClusterPredicate item : predicates){this.addToPredicates(item);}} else { this.predicates = null;} return (A) this;
  }
  public A withPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... predicates) {
    if (this.predicates != null) {this.predicates.clear(); _visitables.remove("predicates"); }
    if (predicates != null) {for (ClusterPredicate item :predicates){ this.addToPredicates(item);}} return (A) this;
  }
  public boolean hasPredicates() {
    return predicates != null && !predicates.isEmpty();
  }
  public PredicatesNested<A> addNewPredicate() {
    return new PredicatesNested(-1, null);
  }
  public PredicatesNested<A> addNewPredicateLike(ClusterPredicate item) {
    return new PredicatesNested(-1, item);
  }
  public PredicatesNested<A> setNewPredicateLike(int index,ClusterPredicate item) {
    return new PredicatesNested(index, item);
  }
  public PredicatesNested<A> editPredicate(int index) {
    if (predicates.size() <= index) throw new RuntimeException("Can't edit predicates. Index exceeds size.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  public PredicatesNested<A> editFirstPredicate() {
    if (predicates.size() == 0) throw new RuntimeException("Can't edit first predicates. The list is empty.");
    return setNewPredicateLike(0, buildPredicate(0));
  }
  public PredicatesNested<A> editLastPredicate() {
    int index = predicates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last predicates. The list is empty.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  public PredicatesNested<A> editMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<predicates.size();i++) { 
    if (predicate.test(predicates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching predicates. No match found.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  public PrioritizerPolicy buildPrioritizerPolicy() {
    return this.prioritizerPolicy!=null ?this.prioritizerPolicy.build():null;
  }
  public A withPrioritizerPolicy(PrioritizerPolicy prioritizerPolicy) {
    _visitables.get("prioritizerPolicy").remove(this.prioritizerPolicy);
    if (prioritizerPolicy!=null){ this.prioritizerPolicy= new PrioritizerPolicyBuilder(prioritizerPolicy); _visitables.get("prioritizerPolicy").add(this.prioritizerPolicy);} else { this.prioritizerPolicy = null; _visitables.get("prioritizerPolicy").remove(this.prioritizerPolicy); } return (A) this;
  }
  public boolean hasPrioritizerPolicy() {
    return this.prioritizerPolicy != null;
  }
  public PrioritizerPolicyNested<A> withNewPrioritizerPolicy() {
    return new PrioritizerPolicyNested(null);
  }
  public PrioritizerPolicyNested<A> withNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return new PrioritizerPolicyNested(item);
  }
  public PrioritizerPolicyNested<A> editPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(null));
  }
  public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(new PrioritizerPolicyBuilder().build()));
  }
  public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return withNewPrioritizerPolicyLike(java.util.Optional.ofNullable(buildPrioritizerPolicy()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementSpecFluent that = (PlacementSpecFluent) o;
    if (!java.util.Objects.equals(clusterSets, that.clusterSets)) return false;

    if (!java.util.Objects.equals(numberOfClusters, that.numberOfClusters)) return false;

    if (!java.util.Objects.equals(predicates, that.predicates)) return false;

    if (!java.util.Objects.equals(prioritizerPolicy, that.prioritizerPolicy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterSets,  numberOfClusters,  predicates,  prioritizerPolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterSets != null && !clusterSets.isEmpty()) { sb.append("clusterSets:"); sb.append(clusterSets + ","); }
    if (numberOfClusters != null) { sb.append("numberOfClusters:"); sb.append(numberOfClusters + ","); }
    if (predicates != null && !predicates.isEmpty()) { sb.append("predicates:"); sb.append(predicates + ","); }
    if (prioritizerPolicy != null) { sb.append("prioritizerPolicy:"); sb.append(prioritizerPolicy); }
    sb.append("}");
    return sb.toString();
  }
  public class PredicatesNested<N> extends ClusterPredicateFluent<PredicatesNested<N>> implements Nested<N>{
    PredicatesNested(int index,ClusterPredicate item) {
      this.index = index;
      this.builder = new ClusterPredicateBuilder(this, item);
    }
    ClusterPredicateBuilder builder;
    int index;
    public N and() {
      return (N) PlacementSpecFluent.this.setToPredicates(index,builder.build());
    }
    public N endPredicate() {
      return and();
    }
    
  }
  public class PrioritizerPolicyNested<N> extends PrioritizerPolicyFluent<PrioritizerPolicyNested<N>> implements Nested<N>{
    PrioritizerPolicyNested(PrioritizerPolicy item) {
      this.builder = new PrioritizerPolicyBuilder(this, item);
    }
    PrioritizerPolicyBuilder builder;
    public N and() {
      return (N) PlacementSpecFluent.this.withPrioritizerPolicy(builder.build());
    }
    public N endPrioritizerPolicy() {
      return and();
    }
    
  }
  
}