package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementListBuilder extends PlacementListFluent<PlacementListBuilder> implements VisitableBuilder<PlacementList,PlacementListBuilder>{
  public PlacementListBuilder() {
    this(false);
  }
  public PlacementListBuilder(Boolean validationEnabled) {
    this(new PlacementList(), validationEnabled);
  }
  public PlacementListBuilder(PlacementListFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementListBuilder(PlacementListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementList(), validationEnabled);
  }
  public PlacementListBuilder(PlacementListFluent<?> fluent,PlacementList instance) {
    this(fluent, instance, false);
  }
  public PlacementListBuilder(PlacementListFluent<?> fluent,PlacementList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlacementList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementListBuilder(PlacementList instance) {
    this(instance,false);
  }
  public PlacementListBuilder(PlacementList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlacementList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementListFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementList build() {
    PlacementList buildable = new PlacementList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}