package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterSelectorBuilder extends ClusterSelectorFluent<ClusterSelectorBuilder> implements VisitableBuilder<ClusterSelector,ClusterSelectorBuilder>{
  public ClusterSelectorBuilder() {
    this(false);
  }
  public ClusterSelectorBuilder(Boolean validationEnabled) {
    this(new ClusterSelector(), validationEnabled);
  }
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterSelector(), validationEnabled);
  }
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent,ClusterSelector instance) {
    this(fluent, instance, false);
  }
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent,ClusterSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterSelector());

    if (instance != null) {
      fluent.withClaimSelector(instance.getClaimSelector());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withClaimSelector(instance.getClaimSelector());
      fluent.withLabelSelector(instance.getLabelSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterSelectorBuilder(ClusterSelector instance) {
    this(instance,false);
  }
  public ClusterSelectorBuilder(ClusterSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterSelector());

    if (instance != null) {
      this.withClaimSelector(instance.getClaimSelector());
      this.withLabelSelector(instance.getLabelSelector());
      this.withClaimSelector(instance.getClaimSelector());
      this.withLabelSelector(instance.getLabelSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterSelector build() {
    ClusterSelector buildable = new ClusterSelector(fluent.buildClaimSelector(),fluent.buildLabelSelector());
    return buildable;
  }
  
}