package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimSelectorBuilder extends ClusterClaimSelectorFluent<ClusterClaimSelectorBuilder> implements VisitableBuilder<ClusterClaimSelector,ClusterClaimSelectorBuilder>{
  public ClusterClaimSelectorBuilder() {
    this(false);
  }
  public ClusterClaimSelectorBuilder(Boolean validationEnabled) {
    this(new ClusterClaimSelector(), validationEnabled);
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaimSelector(), validationEnabled);
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelectorFluent<?> fluent,ClusterClaimSelector instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelectorFluent<?> fluent,ClusterClaimSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterClaimSelector());

    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchExpressions(instance.getMatchExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelector instance) {
    this(instance,false);
  }
  public ClusterClaimSelectorBuilder(ClusterClaimSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterClaimSelector());

    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchExpressions(instance.getMatchExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaimSelector build() {
    ClusterClaimSelector buildable = new ClusterClaimSelector(fluent.getMatchExpressions());
    return buildable;
  }
  
}