package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedClusterStatusFluent<A extends ManagedClusterStatusFluent<A>> extends BaseFluent<A>{
  public ManagedClusterStatusFluent() {
  }
  public ManagedClusterStatusFluent(ManagedClusterStatus instance) {
    instance = (instance != null ? instance : new ManagedClusterStatus());

    if (instance != null) {
      this.withAllocatable(instance.getAllocatable());
      this.withCapacity(instance.getCapacity());
      this.withClusterClaims(instance.getClusterClaims());
      this.withConditions(instance.getConditions());
      this.withVersion(instance.getVersion());
      this.withAllocatable(instance.getAllocatable());
      this.withCapacity(instance.getCapacity());
      this.withClusterClaims(instance.getClusterClaims());
      this.withConditions(instance.getConditions());
      this.withVersion(instance.getVersion());
    }
  }
  private Map<String,Quantity> allocatable;
  private Map<String,Quantity> capacity;
  private ArrayList<ManagedClusterClaimBuilder> clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
  private List<Condition> conditions = new ArrayList<Condition>();
  private ManagedClusterVersionBuilder version;
  public A addToAllocatable(String key,Quantity value) {
    if(this.allocatable == null && key != null && value != null) { this.allocatable = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
  }
  public A addToAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null && map != null) { this.allocatable = new LinkedHashMap(); }
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
  }
  public A removeFromAllocatable(String key) {
    if(this.allocatable == null) { return (A) this; }
    if(key != null && this.allocatable != null) {this.allocatable.remove(key);} return (A)this;
  }
  public A removeFromAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatable != null){this.allocatable.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getAllocatable() {
    return this.allocatable;
  }
  public <K,V>A withAllocatable(Map<String,Quantity> allocatable) {
    if (allocatable == null) { this.allocatable =  null;} else {this.allocatable = new LinkedHashMap(allocatable);} return (A) this;
  }
  public boolean hasAllocatable() {
    return this.allocatable != null;
  }
  public A addToCapacity(String key,Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(Map<String,Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(Map<String,Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(Map<String,Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new LinkedHashMap(capacity);} return (A) this;
  }
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToClusterClaims(int index,ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
    if (index < 0 || index >= clusterClaims.size()) { _visitables.get("clusterClaims").add(builder); clusterClaims.add(builder); } else { _visitables.get("clusterClaims").add(index, builder); clusterClaims.add(index, builder);}
    return (A)this;
  }
  public A setToClusterClaims(int index,ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
    if (index < 0 || index >= clusterClaims.size()) { _visitables.get("clusterClaims").add(builder); clusterClaims.add(builder); } else { _visitables.get("clusterClaims").set(index, builder); clusterClaims.set(index, builder);}
    return (A)this;
  }
  public A addToClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A addAllToClusterClaims(Collection<ManagedClusterClaim> items) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A removeFromClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    if (this.clusterClaims == null) return (A)this;
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder); this.clusterClaims.remove(builder);} return (A)this;
  }
  public A removeAllFromClusterClaims(Collection<ManagedClusterClaim> items) {
    if (this.clusterClaims == null) return (A)this;
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder); this.clusterClaims.remove(builder);} return (A)this;
  }
  public A removeMatchingFromClusterClaims(Predicate<ManagedClusterClaimBuilder> predicate) {
    if (clusterClaims == null) return (A) this;
    final Iterator<ManagedClusterClaimBuilder> each = clusterClaims.iterator();
    final List visitables = _visitables.get("clusterClaims");
    while (each.hasNext()) {
      ManagedClusterClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ManagedClusterClaim> buildClusterClaims() {
    return clusterClaims != null ? build(clusterClaims) : null;
  }
  public ManagedClusterClaim buildClusterClaim(int index) {
    return this.clusterClaims.get(index).build();
  }
  public ManagedClusterClaim buildFirstClusterClaim() {
    return this.clusterClaims.get(0).build();
  }
  public ManagedClusterClaim buildLastClusterClaim() {
    return this.clusterClaims.get(clusterClaims.size() - 1).build();
  }
  public ManagedClusterClaim buildMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    for (ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    for (ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterClaims(List<ManagedClusterClaim> clusterClaims) {
    if (this.clusterClaims != null) { _visitables.get("clusterClaims").clear();}
    if (clusterClaims != null) {this.clusterClaims = new ArrayList(); for (ManagedClusterClaim item : clusterClaims){this.addToClusterClaims(item);}} else { this.clusterClaims = null;} return (A) this;
  }
  public A withClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... clusterClaims) {
    if (this.clusterClaims != null) {this.clusterClaims.clear(); _visitables.remove("clusterClaims"); }
    if (clusterClaims != null) {for (ManagedClusterClaim item :clusterClaims){ this.addToClusterClaims(item);}} return (A) this;
  }
  public boolean hasClusterClaims() {
    return clusterClaims != null && !clusterClaims.isEmpty();
  }
  public A addNewClusterClaim(String name,String value) {
    return (A)addToClusterClaims(new ManagedClusterClaim(name, value));
  }
  public ClusterClaimsNested<A> addNewClusterClaim() {
    return new ClusterClaimsNested(-1, null);
  }
  public ClusterClaimsNested<A> addNewClusterClaimLike(ManagedClusterClaim item) {
    return new ClusterClaimsNested(-1, item);
  }
  public ClusterClaimsNested<A> setNewClusterClaimLike(int index,ManagedClusterClaim item) {
    return new ClusterClaimsNested(index, item);
  }
  public ClusterClaimsNested<A> editClusterClaim(int index) {
    if (clusterClaims.size() <= index) throw new RuntimeException("Can't edit clusterClaims. Index exceeds size.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public ClusterClaimsNested<A> editFirstClusterClaim() {
    if (clusterClaims.size() == 0) throw new RuntimeException("Can't edit first clusterClaims. The list is empty.");
    return setNewClusterClaimLike(0, buildClusterClaim(0));
  }
  public ClusterClaimsNested<A> editLastClusterClaim() {
    int index = clusterClaims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterClaims. The list is empty.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public ClusterClaimsNested<A> editMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterClaims.size();i++) { 
    if (predicate.test(clusterClaims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterClaims. No match found.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ManagedClusterVersion buildVersion() {
    return this.version!=null ?this.version.build():null;
  }
  public A withVersion(ManagedClusterVersion version) {
    _visitables.get("version").remove(this.version);
    if (version!=null){ this.version= new ManagedClusterVersionBuilder(version); _visitables.get("version").add(this.version);} else { this.version = null; _visitables.get("version").remove(this.version); } return (A) this;
  }
  public boolean hasVersion() {
    return this.version != null;
  }
  public A withNewVersion(String kubernetes) {
    return (A)withVersion(new ManagedClusterVersion(kubernetes));
  }
  public VersionNested<A> withNewVersion() {
    return new VersionNested(null);
  }
  public VersionNested<A> withNewVersionLike(ManagedClusterVersion item) {
    return new VersionNested(item);
  }
  public VersionNested<A> editVersion() {
    return withNewVersionLike(java.util.Optional.ofNullable(buildVersion()).orElse(null));
  }
  public VersionNested<A> editOrNewVersion() {
    return withNewVersionLike(java.util.Optional.ofNullable(buildVersion()).orElse(new ManagedClusterVersionBuilder().build()));
  }
  public VersionNested<A> editOrNewVersionLike(ManagedClusterVersion item) {
    return withNewVersionLike(java.util.Optional.ofNullable(buildVersion()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManagedClusterStatusFluent that = (ManagedClusterStatusFluent) o;
    if (!java.util.Objects.equals(allocatable, that.allocatable)) return false;

    if (!java.util.Objects.equals(capacity, that.capacity)) return false;

    if (!java.util.Objects.equals(clusterClaims, that.clusterClaims)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocatable,  capacity,  clusterClaims,  conditions,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocatable != null && !allocatable.isEmpty()) { sb.append("allocatable:"); sb.append(allocatable + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (clusterClaims != null && !clusterClaims.isEmpty()) { sb.append("clusterClaims:"); sb.append(clusterClaims + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterClaimsNested<N> extends ManagedClusterClaimFluent<ClusterClaimsNested<N>> implements Nested<N>{
    ClusterClaimsNested(int index,ManagedClusterClaim item) {
      this.index = index;
      this.builder = new ManagedClusterClaimBuilder(this, item);
    }
    ManagedClusterClaimBuilder builder;
    int index;
    public N and() {
      return (N) ManagedClusterStatusFluent.this.setToClusterClaims(index,builder.build());
    }
    public N endClusterClaim() {
      return and();
    }
    
  }
  public class VersionNested<N> extends ManagedClusterVersionFluent<VersionNested<N>> implements Nested<N>{
    VersionNested(ManagedClusterVersion item) {
      this.builder = new ManagedClusterVersionBuilder(this, item);
    }
    ManagedClusterVersionBuilder builder;
    public N and() {
      return (N) ManagedClusterStatusFluent.this.withVersion(builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}