package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedClusterSpecFluent<A extends ManagedClusterSpecFluent<A>> extends BaseFluent<A>{
  public ManagedClusterSpecFluent() {
  }
  public ManagedClusterSpecFluent(ManagedClusterSpec instance) {
    instance = (instance != null ? instance : new ManagedClusterSpec());

    if (instance != null) {
      this.withHubAcceptsClient(instance.getHubAcceptsClient());
      this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
      this.withHubAcceptsClient(instance.getHubAcceptsClient());
      this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
    }
  }
  private Boolean hubAcceptsClient;
  private Integer leaseDurationSeconds;
  private ArrayList<ClientConfigBuilder> managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
  public Boolean getHubAcceptsClient() {
    return this.hubAcceptsClient;
  }
  public A withHubAcceptsClient(Boolean hubAcceptsClient) {
    this.hubAcceptsClient=hubAcceptsClient; return (A) this;
  }
  public boolean hasHubAcceptsClient() {
    return this.hubAcceptsClient != null;
  }
  public Integer getLeaseDurationSeconds() {
    return this.leaseDurationSeconds;
  }
  public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
    this.leaseDurationSeconds=leaseDurationSeconds; return (A) this;
  }
  public boolean hasLeaseDurationSeconds() {
    return this.leaseDurationSeconds != null;
  }
  public A addToManagedClusterClientConfigs(int index,ClientConfig item) {
    if (this.managedClusterClientConfigs == null) {this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();}
    ClientConfigBuilder builder = new ClientConfigBuilder(item);
    if (index < 0 || index >= managedClusterClientConfigs.size()) { _visitables.get("managedClusterClientConfigs").add(builder); managedClusterClientConfigs.add(builder); } else { _visitables.get("managedClusterClientConfigs").add(index, builder); managedClusterClientConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToManagedClusterClientConfigs(int index,ClientConfig item) {
    if (this.managedClusterClientConfigs == null) {this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();}
    ClientConfigBuilder builder = new ClientConfigBuilder(item);
    if (index < 0 || index >= managedClusterClientConfigs.size()) { _visitables.get("managedClusterClientConfigs").add(builder); managedClusterClientConfigs.add(builder); } else { _visitables.get("managedClusterClientConfigs").set(index, builder); managedClusterClientConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToManagedClusterClientConfigs(io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfig... items) {
    if (this.managedClusterClientConfigs == null) {this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();}
    for (ClientConfig item : items) {ClientConfigBuilder builder = new ClientConfigBuilder(item);_visitables.get("managedClusterClientConfigs").add(builder);this.managedClusterClientConfigs.add(builder);} return (A)this;
  }
  public A addAllToManagedClusterClientConfigs(Collection<ClientConfig> items) {
    if (this.managedClusterClientConfigs == null) {this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();}
    for (ClientConfig item : items) {ClientConfigBuilder builder = new ClientConfigBuilder(item);_visitables.get("managedClusterClientConfigs").add(builder);this.managedClusterClientConfigs.add(builder);} return (A)this;
  }
  public A removeFromManagedClusterClientConfigs(io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfig... items) {
    if (this.managedClusterClientConfigs == null) return (A)this;
    for (ClientConfig item : items) {ClientConfigBuilder builder = new ClientConfigBuilder(item);_visitables.get("managedClusterClientConfigs").remove(builder); this.managedClusterClientConfigs.remove(builder);} return (A)this;
  }
  public A removeAllFromManagedClusterClientConfigs(Collection<ClientConfig> items) {
    if (this.managedClusterClientConfigs == null) return (A)this;
    for (ClientConfig item : items) {ClientConfigBuilder builder = new ClientConfigBuilder(item);_visitables.get("managedClusterClientConfigs").remove(builder); this.managedClusterClientConfigs.remove(builder);} return (A)this;
  }
  public A removeMatchingFromManagedClusterClientConfigs(Predicate<ClientConfigBuilder> predicate) {
    if (managedClusterClientConfigs == null) return (A) this;
    final Iterator<ClientConfigBuilder> each = managedClusterClientConfigs.iterator();
    final List visitables = _visitables.get("managedClusterClientConfigs");
    while (each.hasNext()) {
      ClientConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ClientConfig> buildManagedClusterClientConfigs() {
    return managedClusterClientConfigs != null ? build(managedClusterClientConfigs) : null;
  }
  public ClientConfig buildManagedClusterClientConfig(int index) {
    return this.managedClusterClientConfigs.get(index).build();
  }
  public ClientConfig buildFirstManagedClusterClientConfig() {
    return this.managedClusterClientConfigs.get(0).build();
  }
  public ClientConfig buildLastManagedClusterClientConfig() {
    return this.managedClusterClientConfigs.get(managedClusterClientConfigs.size() - 1).build();
  }
  public ClientConfig buildMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
    for (ClientConfigBuilder item: managedClusterClientConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
    for (ClientConfigBuilder item: managedClusterClientConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withManagedClusterClientConfigs(List<ClientConfig> managedClusterClientConfigs) {
    if (this.managedClusterClientConfigs != null) { _visitables.get("managedClusterClientConfigs").clear();}
    if (managedClusterClientConfigs != null) {this.managedClusterClientConfigs = new ArrayList(); for (ClientConfig item : managedClusterClientConfigs){this.addToManagedClusterClientConfigs(item);}} else { this.managedClusterClientConfigs = null;} return (A) this;
  }
  public A withManagedClusterClientConfigs(io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfig... managedClusterClientConfigs) {
    if (this.managedClusterClientConfigs != null) {this.managedClusterClientConfigs.clear(); _visitables.remove("managedClusterClientConfigs"); }
    if (managedClusterClientConfigs != null) {for (ClientConfig item :managedClusterClientConfigs){ this.addToManagedClusterClientConfigs(item);}} return (A) this;
  }
  public boolean hasManagedClusterClientConfigs() {
    return managedClusterClientConfigs != null && !managedClusterClientConfigs.isEmpty();
  }
  public A addNewManagedClusterClientConfig(String caBundle,String url) {
    return (A)addToManagedClusterClientConfigs(new ClientConfig(caBundle, url));
  }
  public ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfig() {
    return new ManagedClusterClientConfigsNested(-1, null);
  }
  public ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfigLike(ClientConfig item) {
    return new ManagedClusterClientConfigsNested(-1, item);
  }
  public ManagedClusterClientConfigsNested<A> setNewManagedClusterClientConfigLike(int index,ClientConfig item) {
    return new ManagedClusterClientConfigsNested(index, item);
  }
  public ManagedClusterClientConfigsNested<A> editManagedClusterClientConfig(int index) {
    if (managedClusterClientConfigs.size() <= index) throw new RuntimeException("Can't edit managedClusterClientConfigs. Index exceeds size.");
    return setNewManagedClusterClientConfigLike(index, buildManagedClusterClientConfig(index));
  }
  public ManagedClusterClientConfigsNested<A> editFirstManagedClusterClientConfig() {
    if (managedClusterClientConfigs.size() == 0) throw new RuntimeException("Can't edit first managedClusterClientConfigs. The list is empty.");
    return setNewManagedClusterClientConfigLike(0, buildManagedClusterClientConfig(0));
  }
  public ManagedClusterClientConfigsNested<A> editLastManagedClusterClientConfig() {
    int index = managedClusterClientConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last managedClusterClientConfigs. The list is empty.");
    return setNewManagedClusterClientConfigLike(index, buildManagedClusterClientConfig(index));
  }
  public ManagedClusterClientConfigsNested<A> editMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<managedClusterClientConfigs.size();i++) { 
    if (predicate.test(managedClusterClientConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching managedClusterClientConfigs. No match found.");
    return setNewManagedClusterClientConfigLike(index, buildManagedClusterClientConfig(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManagedClusterSpecFluent that = (ManagedClusterSpecFluent) o;
    if (!java.util.Objects.equals(hubAcceptsClient, that.hubAcceptsClient)) return false;

    if (!java.util.Objects.equals(leaseDurationSeconds, that.leaseDurationSeconds)) return false;

    if (!java.util.Objects.equals(managedClusterClientConfigs, that.managedClusterClientConfigs)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hubAcceptsClient,  leaseDurationSeconds,  managedClusterClientConfigs,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hubAcceptsClient != null) { sb.append("hubAcceptsClient:"); sb.append(hubAcceptsClient + ","); }
    if (leaseDurationSeconds != null) { sb.append("leaseDurationSeconds:"); sb.append(leaseDurationSeconds + ","); }
    if (managedClusterClientConfigs != null && !managedClusterClientConfigs.isEmpty()) { sb.append("managedClusterClientConfigs:"); sb.append(managedClusterClientConfigs); }
    sb.append("}");
    return sb.toString();
  }
  public A withHubAcceptsClient() {
    return withHubAcceptsClient(true);
  }
  public class ManagedClusterClientConfigsNested<N> extends ClientConfigFluent<ManagedClusterClientConfigsNested<N>> implements Nested<N>{
    ManagedClusterClientConfigsNested(int index,ClientConfig item) {
      this.index = index;
      this.builder = new ClientConfigBuilder(this, item);
    }
    ClientConfigBuilder builder;
    int index;
    public N and() {
      return (N) ManagedClusterSpecFluent.this.setToManagedClusterClientConfigs(index,builder.build());
    }
    public N endManagedClusterClientConfig() {
      return and();
    }
    
  }
  
}