package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterBuilder extends ManagedClusterFluent<ManagedClusterBuilder> implements VisitableBuilder<ManagedCluster,ManagedClusterBuilder>{
  public ManagedClusterBuilder() {
    this(false);
  }
  public ManagedClusterBuilder(Boolean validationEnabled) {
    this(new ManagedCluster(), validationEnabled);
  }
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedCluster(), validationEnabled);
  }
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent,ManagedCluster instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent,ManagedCluster instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedCluster());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterBuilder(ManagedCluster instance) {
    this(instance,false);
  }
  public ManagedClusterBuilder(ManagedCluster instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedCluster());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedCluster build() {
    ManagedCluster buildable = new ManagedCluster(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}