package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientConfigBuilder extends ClientConfigFluent<ClientConfigBuilder> implements VisitableBuilder<ClientConfig,ClientConfigBuilder>{
  public ClientConfigBuilder() {
    this(false);
  }
  public ClientConfigBuilder(Boolean validationEnabled) {
    this(new ClientConfig(), validationEnabled);
  }
  public ClientConfigBuilder(ClientConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientConfigBuilder(ClientConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClientConfig(), validationEnabled);
  }
  public ClientConfigBuilder(ClientConfigFluent<?> fluent,ClientConfig instance) {
    this(fluent, instance, false);
  }
  public ClientConfigBuilder(ClientConfigFluent<?> fluent,ClientConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClientConfig());

    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withUrl(instance.getUrl());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClientConfigBuilder(ClientConfig instance) {
    this(instance,false);
  }
  public ClientConfigBuilder(ClientConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClientConfig());

    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withUrl(instance.getUrl());
      this.withCaBundle(instance.getCaBundle());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClientConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ClientConfig build() {
    ClientConfig buildable = new ClientConfig(fluent.getCaBundle(),fluent.getUrl());
    return buildable;
  }
  
}