package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentBuilder extends VolumeAttachmentFluentImpl<VolumeAttachmentBuilder> implements VisitableBuilder<VolumeAttachment,VolumeAttachmentBuilder>{

    VolumeAttachmentFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentBuilder(){
            this(true);
    }
    public VolumeAttachmentBuilder(Boolean validationEnabled){
            this(new VolumeAttachment(), validationEnabled);
    }
    public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent){
            this(fluent, true);
    }
    public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolumeAttachment(), validationEnabled);
    }
    public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,VolumeAttachment instance){
            this(fluent, instance, true);
    }
    public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,VolumeAttachment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumeAttachmentBuilder(VolumeAttachment instance){
            this(instance,true);
    }
    public VolumeAttachmentBuilder(VolumeAttachment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachment build(){
            VolumeAttachment buildable = new VolumeAttachment(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeAttachmentBuilder that = (VolumeAttachmentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
