package io.fabric8.kubernetes.api.model.discovery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EndpointFluent<A extends EndpointFluent<A>> extends Fluent<A>{


    public A addToAddresses(int index,String item);
    public A setToAddresses(int index,String item);
    public A addToAddresses(String... items);
    public A addAllToAddresses(Collection<String> items);
    public A removeFromAddresses(String... items);
    public A removeAllFromAddresses(Collection<String> items);
    public List<String> getAddresses();
    public String getAddress(int index);
    public String getFirstAddress();
    public String getLastAddress();
    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAddresses(List<String> addresses);
    public A withAddresses(String... addresses);
    public Boolean hasAddresses();
    public A addNewAddress(String arg1);
    public A addNewAddress(StringBuilder arg1);
    public A addNewAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public EndpointConditions getConditions();
    public EndpointConditions buildConditions();
    public A withConditions(EndpointConditions conditions);
    public Boolean hasConditions();
    public A withNewConditions(Boolean ready);
    public EndpointFluent.ConditionsNested<A> withNewConditions();
    public EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item);
    public EndpointFluent.ConditionsNested<A> editConditions();
    public EndpointFluent.ConditionsNested<A> editOrNewConditions();
    public EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(String arg1);
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getTargetRef();
    public ObjectReference buildTargetRef();
    public A withTargetRef(ObjectReference targetRef);
    public Boolean hasTargetRef();
    public EndpointFluent.TargetRefNested<A> withNewTargetRef();
    public EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item);
    public EndpointFluent.TargetRefNested<A> editTargetRef();
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRef();
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item);
    public A addToTopology(String key,String value);
    public A addToTopology(Map<String,String> map);
    public A removeFromTopology(String key);
    public A removeFromTopology(Map<String,String> map);
    public Map<String,String> getTopology();
    public A withTopology(Map<String,String> topology);
    public Boolean hasTopology();

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointConditionsFluent<EndpointFluent.ConditionsNested<N>>{

        
    public N and();    public N endConditions();
}
    public interface TargetRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<EndpointFluent.TargetRefNested<N>>{

        
    public N and();    public N endTargetRef();
}


}
