package io.fabric8.kubernetes.api.model.coordination.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.StringBuffer;
import java.time.ZonedDateTime;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface LeaseSpecFluent<A extends LeaseSpecFluent<A>> extends Fluent<A>{


    public ZonedDateTime getAcquireTime();
    public A withAcquireTime(ZonedDateTime acquireTime);
    public Boolean hasAcquireTime();
    public String getHolderIdentity();
    public A withHolderIdentity(String holderIdentity);
    public Boolean hasHolderIdentity();
    public A withNewHolderIdentity(String arg1);
    public A withNewHolderIdentity(StringBuilder arg1);
    public A withNewHolderIdentity(StringBuffer arg1);
    public Integer getLeaseDurationSeconds();
    public A withLeaseDurationSeconds(Integer leaseDurationSeconds);
    public Boolean hasLeaseDurationSeconds();
    public Integer getLeaseTransitions();
    public A withLeaseTransitions(Integer leaseTransitions);
    public Boolean hasLeaseTransitions();
    public ZonedDateTime getRenewTime();
    public A withRenewTime(ZonedDateTime renewTime);
    public Boolean hasRenewTime();
    public A addToAdditionalProperties(String key,Object value);
    public A addToAdditionalProperties(Map<String,Object> map);
    public A removeFromAdditionalProperties(String key);
    public A removeFromAdditionalProperties(Map<String,Object> map);
    public Map<String,Object> getAdditionalProperties();
    public A withAdditionalProperties(Map<String,Object> additionalProperties);
    public Boolean hasAdditionalProperties();



}
