package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;

public class MetricTargetFluentImpl<A extends MetricTargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricTargetFluent<A>{

    private Integer averageUtilization;
    private QuantityBuilder averageValue;
    private String type;
    private QuantityBuilder value;

    public MetricTargetFluentImpl(){
    }
    public MetricTargetFluentImpl(MetricTarget instance){
            this.withAverageUtilization(instance.getAverageUtilization()); 
            this.withAverageValue(instance.getAverageValue()); 
            this.withType(instance.getType()); 
            this.withValue(instance.getValue()); 
    }

    public Integer getAverageUtilization(){
            return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization){
            this.averageUtilization=averageUtilization; return (A) this;
    }

    public Boolean hasAverageUtilization(){
            return this.averageUtilization != null;
    }

    
/**
 * This method has been deprecated, please use method buildAverageValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getAverageValue(){
            return this.averageValue!=null?this.averageValue.build():null;
    }

    public Quantity buildAverageValue(){
            return this.averageValue!=null?this.averageValue.build():null;
    }

    public A withAverageValue(Quantity averageValue){
            _visitables.get("averageValue").remove(this.averageValue);
            if (averageValue!=null){ this.averageValue= new QuantityBuilder(averageValue); _visitables.get("averageValue").add(this.averageValue);} return (A) this;
    }

    public Boolean hasAverageValue(){
            return this.averageValue != null;
    }

    public A withNewAverageValue(String amount,String format){
            return (A)withAverageValue(new Quantity(amount, format));
    }

    public A withNewAverageValue(String amount){
            return (A)withAverageValue(new Quantity(amount));
    }

    public MetricTargetFluent.AverageValueNested<A> withNewAverageValue(){
            return new AverageValueNestedImpl();
    }

    public MetricTargetFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item){
            return new AverageValueNestedImpl(item);
    }

    public MetricTargetFluent.AverageValueNested<A> editAverageValue(){
            return withNewAverageValueLike(getAverageValue());
    }

    public MetricTargetFluent.AverageValueNested<A> editOrNewAverageValue(){
            return withNewAverageValueLike(getAverageValue() != null ? getAverageValue(): new QuantityBuilder().build());
    }

    public MetricTargetFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item){
            return withNewAverageValueLike(getAverageValue() != null ? getAverageValue(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getValue(){
            return this.value!=null?this.value.build():null;
    }

    public Quantity buildValue(){
            return this.value!=null?this.value.build():null;
    }

    public A withValue(Quantity value){
            _visitables.get("value").remove(this.value);
            if (value!=null){ this.value= new QuantityBuilder(value); _visitables.get("value").add(this.value);} return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public A withNewValue(String amount,String format){
            return (A)withValue(new Quantity(amount, format));
    }

    public A withNewValue(String amount){
            return (A)withValue(new Quantity(amount));
    }

    public MetricTargetFluent.ValueNested<A> withNewValue(){
            return new ValueNestedImpl();
    }

    public MetricTargetFluent.ValueNested<A> withNewValueLike(Quantity item){
            return new ValueNestedImpl(item);
    }

    public MetricTargetFluent.ValueNested<A> editValue(){
            return withNewValueLike(getValue());
    }

    public MetricTargetFluent.ValueNested<A> editOrNewValue(){
            return withNewValueLike(getValue() != null ? getValue(): new QuantityBuilder().build());
    }

    public MetricTargetFluent.ValueNested<A> editOrNewValueLike(Quantity item){
            return withNewValueLike(getValue() != null ? getValue(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MetricTargetFluentImpl that = (MetricTargetFluentImpl) o;
            if (averageUtilization != null ? !averageUtilization.equals(that.averageUtilization) :that.averageUtilization != null) return false;
            if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }


    public class AverageValueNestedImpl<N> extends QuantityFluentImpl<MetricTargetFluent.AverageValueNested<N>> implements MetricTargetFluent.AverageValueNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final QuantityBuilder builder;
    
            AverageValueNestedImpl(Quantity item){
                    this.builder = new QuantityBuilder(this, item);
            }
            AverageValueNestedImpl(){
                    this.builder = new QuantityBuilder(this);
            }
    
    public N and(){
            return (N) MetricTargetFluentImpl.this.withAverageValue(builder.build());
    }
    public N endAverageValue(){
            return and();
    }

}
    public class ValueNestedImpl<N> extends QuantityFluentImpl<MetricTargetFluent.ValueNested<N>> implements MetricTargetFluent.ValueNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final QuantityBuilder builder;
    
            ValueNestedImpl(Quantity item){
                    this.builder = new QuantityBuilder(this, item);
            }
            ValueNestedImpl(){
                    this.builder = new QuantityBuilder(this);
            }
    
    public N and(){
            return (N) MetricTargetFluentImpl.this.withValue(builder.build());
    }
    public N endValue(){
            return and();
    }

}


}
