package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface MetricTargetFluent<A extends MetricTargetFluent<A>> extends Fluent<A>{


    public Integer getAverageUtilization();
    public A withAverageUtilization(Integer averageUtilization);
    public Boolean hasAverageUtilization();
    
/**
 * This method has been deprecated, please use method buildAverageValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getAverageValue();
    public Quantity buildAverageValue();
    public A withAverageValue(Quantity averageValue);
    public Boolean hasAverageValue();
    public A withNewAverageValue(String amount,String format);
    public A withNewAverageValue(String amount);
    public MetricTargetFluent.AverageValueNested<A> withNewAverageValue();
    public MetricTargetFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item);
    public MetricTargetFluent.AverageValueNested<A> editAverageValue();
    public MetricTargetFluent.AverageValueNested<A> editOrNewAverageValue();
    public MetricTargetFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item);
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(String arg1);
    public A withNewType(StringBuilder arg1);
    public A withNewType(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getValue();
    public Quantity buildValue();
    public A withValue(Quantity value);
    public Boolean hasValue();
    public A withNewValue(String amount,String format);
    public A withNewValue(String amount);
    public MetricTargetFluent.ValueNested<A> withNewValue();
    public MetricTargetFluent.ValueNested<A> withNewValueLike(Quantity item);
    public MetricTargetFluent.ValueNested<A> editValue();
    public MetricTargetFluent.ValueNested<A> editOrNewValue();
    public MetricTargetFluent.ValueNested<A> editOrNewValueLike(Quantity item);

    public interface AverageValueNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuantityFluent<MetricTargetFluent.AverageValueNested<N>>{

        
    public N and();    public N endAverageValue();
}
    public interface ValueNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuantityFluent<MetricTargetFluent.ValueNested<N>>{

        
    public N and();    public N endValue();
}


}
