package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface EphemeralContainerFluent<A extends EphemeralContainerFluent<A>> extends Fluent<A>{


    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(String arg1);
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(StringBuffer arg1);
    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingCommand(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(String arg1);
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(StringBuffer arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public A removeMatchingFromEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVarBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvVar> getEnv();
    public List<EnvVar> buildEnv();
    public EnvVar buildEnv(int index);
    public EnvVar buildFirstEnv();
    public EnvVar buildLastEnv();
    public EnvVar buildMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVarBuilder> predicate);
    public Boolean hasMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVarBuilder> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public EphemeralContainerFluent.EnvNested<A> addNewEnv();
    public EphemeralContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public EphemeralContainerFluent.EnvNested<A> setNewEnvLike(int index,EnvVar item);
    public EphemeralContainerFluent.EnvNested<A> editEnv(int index);
    public EphemeralContainerFluent.EnvNested<A> editFirstEnv();
    public EphemeralContainerFluent.EnvNested<A> editLastEnv();
    public EphemeralContainerFluent.EnvNested<A> editMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVarBuilder> predicate);
    public A addToEnvFrom(int index,EnvFromSource item);
    public A setToEnvFrom(int index,EnvFromSource item);
    public A addToEnvFrom(EnvFromSource... items);
    public A addAllToEnvFrom(Collection<EnvFromSource> items);
    public A removeFromEnvFrom(EnvFromSource... items);
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items);
    public A removeMatchingFromEnvFrom(io.fabric8.kubernetes.api.builder.Predicate<EnvFromSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnvFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvFromSource> getEnvFrom();
    public List<EnvFromSource> buildEnvFrom();
    public EnvFromSource buildEnvFrom(int index);
    public EnvFromSource buildFirstEnvFrom();
    public EnvFromSource buildLastEnvFrom();
    public EnvFromSource buildMatchingEnvFrom(io.fabric8.kubernetes.api.builder.Predicate<EnvFromSourceBuilder> predicate);
    public Boolean hasMatchingEnvFrom(io.fabric8.kubernetes.api.builder.Predicate<EnvFromSourceBuilder> predicate);
    public A withEnvFrom(List<EnvFromSource> envFrom);
    public A withEnvFrom(EnvFromSource... envFrom);
    public Boolean hasEnvFrom();
    public EphemeralContainerFluent.EnvFromNested<A> addNewEnvFrom();
    public EphemeralContainerFluent.EnvFromNested<A> addNewEnvFromLike(EnvFromSource item);
    public EphemeralContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,EnvFromSource item);
    public EphemeralContainerFluent.EnvFromNested<A> editEnvFrom(int index);
    public EphemeralContainerFluent.EnvFromNested<A> editFirstEnvFrom();
    public EphemeralContainerFluent.EnvFromNested<A> editLastEnvFrom();
    public EphemeralContainerFluent.EnvFromNested<A> editMatchingEnvFrom(io.fabric8.kubernetes.api.builder.Predicate<EnvFromSourceBuilder> predicate);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Boolean hasImagePullPolicy();
    public A withNewImagePullPolicy(String arg1);
    public A withNewImagePullPolicy(StringBuilder arg1);
    public A withNewImagePullPolicy(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLifecycle instead.
 * @return The buildable object.
 */
@Deprecated public Lifecycle getLifecycle();
    public Lifecycle buildLifecycle();
    public A withLifecycle(Lifecycle lifecycle);
    public Boolean hasLifecycle();
    public EphemeralContainerFluent.LifecycleNested<A> withNewLifecycle();
    public EphemeralContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item);
    public EphemeralContainerFluent.LifecycleNested<A> editLifecycle();
    public EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycle();
    public EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item);
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public EphemeralContainerFluent.LivenessProbeNested<A> editLivenessProbe();
    public EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToPorts(int index,ContainerPort item);
    public A setToPorts(int index,ContainerPort item);
    public A addToPorts(ContainerPort... items);
    public A addAllToPorts(Collection<ContainerPort> items);
    public A removeFromPorts(ContainerPort... items);
    public A removeAllFromPorts(Collection<ContainerPort> items);
    public A removeMatchingFromPorts(io.fabric8.kubernetes.api.builder.Predicate<ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerPort> getPorts();
    public List<ContainerPort> buildPorts();
    public ContainerPort buildPort(int index);
    public ContainerPort buildFirstPort();
    public ContainerPort buildLastPort();
    public ContainerPort buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<ContainerPortBuilder> predicate);
    public Boolean hasMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<ContainerPortBuilder> predicate);
    public A withPorts(List<ContainerPort> ports);
    public A withPorts(ContainerPort... ports);
    public Boolean hasPorts();
    public A addNewPort(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol);
    public EphemeralContainerFluent.PortsNested<A> addNewPort();
    public EphemeralContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item);
    public EphemeralContainerFluent.PortsNested<A> setNewPortLike(int index,ContainerPort item);
    public EphemeralContainerFluent.PortsNested<A> editPort(int index);
    public EphemeralContainerFluent.PortsNested<A> editFirstPort();
    public EphemeralContainerFluent.PortsNested<A> editLastPort();
    public EphemeralContainerFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public EphemeralContainerFluent.ReadinessProbeNested<A> editReadinessProbe();
    public EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public EphemeralContainerFluent.ResourcesNested<A> withNewResources();
    public EphemeralContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public EphemeralContainerFluent.ResourcesNested<A> editResources();
    public EphemeralContainerFluent.ResourcesNested<A> editOrNewResources();
    public EphemeralContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public SecurityContext getSecurityContext();
    public SecurityContext buildSecurityContext();
    public A withSecurityContext(SecurityContext securityContext);
    public Boolean hasSecurityContext();
    public EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContext();
    public EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item);
    public EphemeralContainerFluent.SecurityContextNested<A> editSecurityContext();
    public EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item);
    
/**
 * This method has been deprecated, please use method buildStartupProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getStartupProbe();
    public Probe buildStartupProbe();
    public A withStartupProbe(Probe startupProbe);
    public Boolean hasStartupProbe();
    public EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbe();
    public EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(Probe item);
    public EphemeralContainerFluent.StartupProbeNested<A> editStartupProbe();
    public EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbe();
    public EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(Probe item);
    public Boolean isStdin();
    public A withStdin(Boolean stdin);
    public Boolean hasStdin();
    public A withNewStdin(String arg1);
    public A withNewStdin(boolean arg1);
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public Boolean hasStdinOnce();
    public A withNewStdinOnce(String arg1);
    public A withNewStdinOnce(boolean arg1);
    public String getTargetContainerName();
    public A withTargetContainerName(String targetContainerName);
    public Boolean hasTargetContainerName();
    public A withNewTargetContainerName(String arg1);
    public A withNewTargetContainerName(StringBuilder arg1);
    public A withNewTargetContainerName(StringBuffer arg1);
    public String getTerminationMessagePath();
    public A withTerminationMessagePath(String terminationMessagePath);
    public Boolean hasTerminationMessagePath();
    public A withNewTerminationMessagePath(String arg1);
    public A withNewTerminationMessagePath(StringBuilder arg1);
    public A withNewTerminationMessagePath(StringBuffer arg1);
    public String getTerminationMessagePolicy();
    public A withTerminationMessagePolicy(String terminationMessagePolicy);
    public Boolean hasTerminationMessagePolicy();
    public A withNewTerminationMessagePolicy(String arg1);
    public A withNewTerminationMessagePolicy(StringBuilder arg1);
    public A withNewTerminationMessagePolicy(StringBuffer arg1);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public Boolean hasTty();
    public A withNewTty(String arg1);
    public A withNewTty(boolean arg1);
    public A addToVolumeDevices(int index,VolumeDevice item);
    public A setToVolumeDevices(int index,VolumeDevice item);
    public A addToVolumeDevices(VolumeDevice... items);
    public A addAllToVolumeDevices(Collection<VolumeDevice> items);
    public A removeFromVolumeDevices(VolumeDevice... items);
    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items);
    public A removeMatchingFromVolumeDevices(io.fabric8.kubernetes.api.builder.Predicate<VolumeDeviceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeDevices instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeDevice> getVolumeDevices();
    public List<VolumeDevice> buildVolumeDevices();
    public VolumeDevice buildVolumeDevice(int index);
    public VolumeDevice buildFirstVolumeDevice();
    public VolumeDevice buildLastVolumeDevice();
    public VolumeDevice buildMatchingVolumeDevice(io.fabric8.kubernetes.api.builder.Predicate<VolumeDeviceBuilder> predicate);
    public Boolean hasMatchingVolumeDevice(io.fabric8.kubernetes.api.builder.Predicate<VolumeDeviceBuilder> predicate);
    public A withVolumeDevices(List<VolumeDevice> volumeDevices);
    public A withVolumeDevices(VolumeDevice... volumeDevices);
    public Boolean hasVolumeDevices();
    public A addNewVolumeDevice(String devicePath,String name);
    public EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice();
    public EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item);
    public EphemeralContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,VolumeDevice item);
    public EphemeralContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index);
    public EphemeralContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice();
    public EphemeralContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice();
    public EphemeralContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(io.fabric8.kubernetes.api.builder.Predicate<VolumeDeviceBuilder> predicate);
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public A removeMatchingFromVolumeMounts(io.fabric8.kubernetes.api.builder.Predicate<VolumeMountBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts();
    public List<VolumeMount> buildVolumeMounts();
    public VolumeMount buildVolumeMount(int index);
    public VolumeMount buildFirstVolumeMount();
    public VolumeMount buildLastVolumeMount();
    public VolumeMount buildMatchingVolumeMount(io.fabric8.kubernetes.api.builder.Predicate<VolumeMountBuilder> predicate);
    public Boolean hasMatchingVolumeMount(io.fabric8.kubernetes.api.builder.Predicate<VolumeMountBuilder> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMount();
    public EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item);
    public EphemeralContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item);
    public EphemeralContainerFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public EphemeralContainerFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public EphemeralContainerFluent.VolumeMountsNested<A> editLastVolumeMount();
    public EphemeralContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(io.fabric8.kubernetes.api.builder.Predicate<VolumeMountBuilder> predicate);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean hasWorkingDir();
    public A withNewWorkingDir(String arg1);
    public A withNewWorkingDir(StringBuilder arg1);
    public A withNewWorkingDir(StringBuffer arg1);

    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<EphemeralContainerFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface EnvFromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvFromSourceFluent<EphemeralContainerFluent.EnvFromNested<N>>{

        
    public N and();    public N endEnvFrom();
}
    public interface LifecycleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LifecycleFluent<EphemeralContainerFluent.LifecycleNested<N>>{

        
    public N and();    public N endLifecycle();
}
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EphemeralContainerFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerPortFluent<EphemeralContainerFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EphemeralContainerFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<EphemeralContainerFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextFluent<EphemeralContainerFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface StartupProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EphemeralContainerFluent.StartupProbeNested<N>>{

        
    public N and();    public N endStartupProbe();
}
    public interface VolumeDevicesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeDeviceFluent<EphemeralContainerFluent.VolumeDevicesNested<N>>{

        
    public N and();    public N endVolumeDevice();
}
    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeMountFluent<EphemeralContainerFluent.VolumeMountsNested<N>>{

        
    public N and();    public N endVolumeMount();
}


}
