/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ProjectSpec;
import io.fabric8.openshift.api.model.ProjectSpecFluent;
import io.fabric8.openshift.api.model.ProjectSpecFluentImpl;
import javax.validation.Validator;

public class ProjectSpecBuilder
extends ProjectSpecFluentImpl<ProjectSpecBuilder>
implements VisitableBuilder<ProjectSpec, ProjectSpecBuilder> {
    ProjectSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ProjectSpecBuilder() {
        this(true);
    }

    public ProjectSpecBuilder(Boolean validationEnabled) {
        this(new ProjectSpec(), validationEnabled);
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ProjectSpec(), validationEnabled);
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent, ProjectSpec instance) {
        this(fluent, instance, true);
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent, ProjectSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFinalizers(instance.getFinalizers());
        this.validationEnabled = validationEnabled;
    }

    public ProjectSpecBuilder(ProjectSpec instance) {
        this(instance, (Boolean)true);
    }

    public ProjectSpecBuilder(ProjectSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFinalizers(instance.getFinalizers());
        this.validationEnabled = validationEnabled;
    }

    public ProjectSpecBuilder(Validator validator) {
        this(new ProjectSpec(), (Boolean)true);
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent, ProjectSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withFinalizers(instance.getFinalizers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ProjectSpecBuilder(ProjectSpec instance, Validator validator) {
        this.fluent = this;
        this.withFinalizers(instance.getFinalizers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ProjectSpec build() {
        ProjectSpec buildable = new ProjectSpec(this.fluent.getFinalizers());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectSpecBuilder that = (ProjectSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

