/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedInformerExample {
    private static final Logger logger = LoggerFactory.getLogger(SharedInformerExample.class);
    private static final String POD_NAME = "myapp-pod";

    public static void main(String[] args) throws InterruptedException {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            SharedInformerFactory sharedInformerFactory = client.informers();
            SharedIndexInformer podInformer = sharedInformerFactory.sharedIndexInformerFor(Pod.class, 30000L);
            logger.info("Informer factory initialized.");
            podInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<Pod>(){

                public void onAdd(Pod pod) {
                    logger.info("{} pod added", (Object)pod.getMetadata().getName());
                }

                public void onUpdate(Pod oldPod, Pod newPod) {
                    logger.info("{} pod updated", (Object)oldPod.getMetadata().getName());
                }

                public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
                    logger.info("{} pod deleted", (Object)pod.getMetadata().getName());
                }
            });
            logger.info("Starting all registered informers");
            sharedInformerFactory.startAllRegisteredInformers();
            Pod testPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(POD_NAME)).withLabels(Collections.singletonMap("app", POD_NAME))).endMetadata()).withNewSpec().addNewContainer().withName("myapp-container")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo The app is running!; sleep 10"})).endContainer()).addNewInitContainer().withName("init-myservice")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo inititalizing...; sleep 5"})).endInitContainer()).endSpec()).build();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).resource((Object)testPod)).create();
            logger.info("Pod created");
            Thread.sleep(3000L);
            Lister podLister = new Lister(podInformer.getIndexer(), "default");
            Pod myPod = (Pod)podLister.get(POD_NAME);
            logger.info("PodLister has {}", (Object)podLister.list().size());
            if (myPod != null) {
                logger.info("***** myapp-pod created {}", (Object)myPod.getMetadata().getCreationTimestamp());
            }
            TimeUnit.MINUTES.sleep(3L);
            podInformer.close();
            sharedInformerFactory.stopAllRegisteredInformers();
        }
    }
}

