/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassBuilder;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodPriorityExample {
    private static final Logger logger = LoggerFactory.getLogger(PodPriorityExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            PriorityClass priorityClass = ((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassFluent.MetadataNested)new PriorityClassBuilder().withNewMetadata().withName("high-priority")).endMetadata()).withValue(Integer.valueOf(100000))).withGlobalDefault(Boolean.valueOf(false))).withDescription("This priority class should be used for XYZ service pods only.")).build();
            ((Resource)client.scheduling().v1().priorityClasses().resource((Object)priorityClass)).create();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).resource((Object)((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("nginx")).withLabels(Collections.singletonMap("env", "test"))).endMetadata()).withNewSpec().addToContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("nginx")).withImage("nginx")).withImagePullPolicy("IfNotPresent")).build()})).withPriorityClassName("high-priority")).endSpec()).build())).create();
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

