/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.support;

import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.List;
import java.util.Map;

public class DockerCommandPlainPrint {
    private static final String DOCKER_PREFIX_LOG_OUTPUT = "docker run -dP ";
    private StringBuilder dockerPlainTextCommand;

    public DockerCommandPlainPrint(StringBuilder dockerPlainTextCommand) {
        this.dockerPlainTextCommand = dockerPlainTextCommand;
        this.dockerPlainTextCommand.append(DOCKER_PREFIX_LOG_OUTPUT);
    }

    public StringBuilder getDockerPlainTextCommand() {
        return this.dockerPlainTextCommand;
    }

    public void setDockerPlainTextCommand(StringBuilder dockerPlainTextCommand) {
        this.dockerPlainTextCommand = dockerPlainTextCommand;
    }

    public void appendParameters(Map<String, String> data, String flag) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.dockerPlainTextCommand.append(flag);
            this.dockerPlainTextCommand.append(" ");
            this.dockerPlainTextCommand.append(entry.getKey());
            this.dockerPlainTextCommand.append("=");
            this.dockerPlainTextCommand.append(entry.getValue());
            this.dockerPlainTextCommand.append(" ");
        }
    }

    public void appendVolumeMounts(List<VolumeMount> volumesMount, String flag) {
        for (VolumeMount vol : volumesMount) {
            this.dockerPlainTextCommand.append(flag);
            this.dockerPlainTextCommand.append(" ");
            this.dockerPlainTextCommand.append(vol.getMountPath().toString());
            if (vol.getReadOnly().booleanValue()) {
                this.dockerPlainTextCommand.append(":");
                this.dockerPlainTextCommand.append("ro");
            }
            this.dockerPlainTextCommand.append(" ");
        }
    }

    public void appendContainerPorts(List<ContainerPort> containerPorts, String flag) {
        for (ContainerPort port : containerPorts) {
            this.dockerPlainTextCommand.append(flag);
            this.dockerPlainTextCommand.append(" ");
            if (port.getHostIP() != null && !port.getHostIP().isEmpty()) {
                this.dockerPlainTextCommand.append(port.getHostIP());
                this.dockerPlainTextCommand.append(":");
            }
            if (port.getHostPort() != null) {
                this.dockerPlainTextCommand.append(port.getHostPort());
                this.dockerPlainTextCommand.append(":");
            }
            if (port.getHostIP() != null && !port.getHostIP().isEmpty() && port.getHostPort() == null) {
                this.dockerPlainTextCommand.append(":");
            }
            this.dockerPlainTextCommand.append(port.getContainerPort());
            this.dockerPlainTextCommand.append(" ");
        }
    }

    public void appendImageName(String imageName) {
        this.dockerPlainTextCommand.append(imageName);
    }
}

