/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.ProjectPaths;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;

public class BuildDirs {
    private final Path projectBasePath;
    private final Path buildPath;
    private final String buildTopDir;

    public BuildDirs(ProjectPaths projectPaths, String imageName) {
        this.buildTopDir = imageName.replace(':', File.separatorChar).replace('/', File.separatorChar);
        this.projectBasePath = projectPaths.getProjectBasePath();
        this.buildPath = projectPaths.getOutputPath().resolve(this.buildTopDir);
    }

    public BuildDirs(@Nonnull String imageName, MojoParameters params) {
        this(new ProjectPaths(params.getProject().getBasedir(), params.getOutputDirectory()), imageName);
    }

    public String getBuildTopDir() {
        return this.buildTopDir;
    }

    public File getOutputDirectory() {
        return this.getDir("build");
    }

    public File getWorkingDirectory() {
        return this.getDir("work");
    }

    public File getTemporaryRootDirectory() {
        return this.getDir("tmp");
    }

    public Path getBuildPath(String subdir) {
        return this.buildPath.resolve(subdir);
    }

    public Path getProjectPath(String subdir) {
        return this.projectBasePath.resolve(subdir);
    }

    private File getDir(String subdir) {
        return this.getBuildPath(subdir).toFile();
    }

    void createDirs() {
        for (String workDir : new String[]{"build", "work", "tmp"}) {
            Path dir = this.getBuildPath(workDir);
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot create directory " + dir);
            }
        }
    }
}

