/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import com.google.common.collect.ImmutableList;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.ExecException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RegistryAuthConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.DockerAccessFactory;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.ServiceHubFactory;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.GavLabel;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.NamePatternUtil;
import io.fabric8.maven.docker.util.ProjectPaths;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.fusesource.jansi.Ansi;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements Contextualizable,
ConfigHelper.Customizer {
    public static final String CONTEXT_KEY_START_CALLED = "CONTEXT_KEY_DOCKER_START_CALLED";
    public static final String CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String CONTEXT_KEY_BUILD_TIMESTAMP = "CONTEXT_KEY_BUILD_TIMESTAMP";
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="session")
    protected MavenSession session;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Component
    protected ServiceHubFactory serviceHubFactory;
    @Component
    protected DockerAccessFactory dockerAccessFactory;
    @Parameter(property="outputFile")
    private String outputFile;
    @Parameter(property="docker.autoPull")
    protected String autoPull;
    @Parameter(property="docker.imagePullPolicy")
    protected String imagePullPolicy;
    @Parameter(property="docker.keepContainer", defaultValue="false")
    protected boolean keepContainer;
    @Parameter(property="docker.removeVolumes", defaultValue="false")
    protected boolean removeVolumes;
    @Parameter(property="docker.apiVersion")
    private String apiVersion;
    @Parameter(property="docker.host")
    private String dockerHost;
    @Parameter(property="docker.certPath")
    private String certPath;
    @Parameter(property="docker.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="docker.verbose")
    protected String verbose;
    @Parameter(property="docker.logDate")
    private String logDate;
    @Parameter(property="docker.logStdout", defaultValue="false")
    private boolean logStdout;
    @Parameter(property="docker.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="docker.skip.machine", defaultValue="false")
    private boolean skipMachine;
    @Parameter(property="docker.filter")
    private String filter;
    @Parameter(property="docker.registry")
    protected String registry;
    @Parameter(property="docker.skip.extendedAuth", defaultValue="false")
    protected boolean skipExtendedAuth;
    @Parameter(property="docker.maxConnections", defaultValue="100")
    private int maxConnections;
    @Parameter(property="docker.build.jib", defaultValue="false")
    public boolean jib;
    @Parameter(property="docker.build.jib.imageFormat", defaultValue="docker")
    public String jibImageFormat;
    @Parameter(property="docker.source.dir", defaultValue="src/main/docker")
    public String sourceDirectory;
    @Parameter(property="docker.target.dir", defaultValue="target/docker")
    public String outputDirectory;
    @Parameter
    private RegistryAuthConfiguration authConfig;
    @Parameter
    private List<VolumeConfiguration> volumes;
    @Parameter
    List<ImageConfiguration> images;
    @Parameter
    private Map<String, ImageConfiguration> imagesMap;
    @Parameter
    private DockerMachineConfiguration machine;
    @Parameter(defaultValue="${project.packaging}", required=true)
    protected String packaging;
    @Parameter(property="docker.skip.pom", defaultValue="false")
    protected boolean skipPom;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter
    protected MavenArchiveConfiguration archive;
    @Component
    protected MavenFileFilter mavenFileFilter;
    @Component
    protected MavenReaderFilter mavenFilterReader;
    @Parameter
    protected Map<String, String> buildArgs;
    List<ImageConfiguration> resolvedImages;
    AuthConfigFactory authConfigFactory;
    protected AnsiLogger log;
    private String minimalApiVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            boolean ansiRestore = Ansi.isEnabled();
            File output = null;
            if (this.outputFile != null && (output = new File(this.outputFile)).exists()) {
                output.delete();
            }
            this.log = new AnsiLogger(this.getLog(), this.useColorForLogging(), this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix(), output);
            try {
                this.authConfigFactory.setLog(this.log);
                this.imageConfigResolver.setLog(this.log);
                LogOutputSpecFactory logSpecFactory = new LogOutputSpecFactory(this.useColor, this.logStdout, this.logDate);
                ConfigHelper.validateExternalPropertyActivation(this.project, this.getAllImages());
                DockerAccess access = null;
                try {
                    this.minimalApiVersion = this.initImageConfiguration(this.getBuildTimestamp());
                    if (this.isDockerAccessRequired()) {
                        DockerAccessFactory.DockerAccessContext dockerAccessContext = this.getDockerAccessContext();
                        access = this.dockerAccessFactory.createDockerAccess(dockerAccessContext);
                    }
                    ServiceHub serviceHub = this.serviceHubFactory.createServiceHub(this.project, this.session, access, this.log, logSpecFactory);
                    this.executeInternal(serviceHub);
                }
                catch (ExecException | IOException exp) {
                    this.logException(exp);
                    throw new MojoExecutionException(this.log.errorMessage(exp.getMessage()), exp);
                }
                catch (MojoExecutionException exp) {
                    this.logException((Exception)((Object)exp));
                    throw exp;
                }
                finally {
                    if (access != null) {
                        access.shutdown();
                    }
                }
            }
            finally {
                Ansi.setEnabled((boolean)ansiRestore);
                try {
                    this.log.close();
                }
                catch (IOException exp) {
                    this.logException(exp);
                }
            }
        }
    }

    private void logException(Exception exp) {
        if (exp.getCause() != null) {
            this.log.error("%s [%s]", exp.getMessage(), exp.getCause().getMessage());
        } else {
            this.log.error("%s", exp.getMessage());
        }
    }

    protected DockerAccessFactory.DockerAccessContext getDockerAccessContext() {
        return new DockerAccessFactory.DockerAccessContext.Builder().dockerHost(this.dockerHost).certPath(this.certPath).machine(this.machine).maxConnections(this.maxConnections).minimalApiVersion(this.minimalApiVersion).projectProperties(this.project.getProperties()).skipMachine(this.skipMachine).log(this.log).build();
    }

    protected RegistryService.RegistryConfig getRegistryConfig(String specificRegistry) {
        return new RegistryService.RegistryConfig.Builder().settings(this.settings).authConfig(this.authConfig != null ? this.authConfig.toMap() : null).authConfigFactory(this.authConfigFactory).skipExtendedAuth(this.skipExtendedAuth).registry(specificRegistry != null ? specificRegistry : this.registry).build();
    }

    protected synchronized Date getBuildTimestamp() throws IOException {
        Date now = (Date)this.getPluginContext().get(CONTEXT_KEY_BUILD_TIMESTAMP);
        if (now == null) {
            now = this.getReferenceDate();
            this.getPluginContext().put(CONTEXT_KEY_BUILD_TIMESTAMP, now);
        }
        return now;
    }

    protected Date getReferenceDate() throws IOException {
        Date referenceDate = EnvUtil.loadTimestamp(this.getBuildTimestampFile());
        return referenceDate != null ? referenceDate : new Date();
    }

    protected File getBuildTimestampFile() {
        return new File(this.project.getBuild().getDirectory(), DOCKER_BUILD_TIMESTAMP);
    }

    protected String getLogPrefix() {
        return "DOCKER> ";
    }

    private boolean useColorForLogging() {
        return this.useColor && MessageUtils.isColorEnabled() && (!EnvUtil.isWindows() || EnvUtil.isMaven350OrLater(this.session));
    }

    private String initImageConfiguration(Date buildTimeStamp) {
        this.resolvedImages = ConfigHelper.resolveImages(this.log, this.getAllImages(), new ConfigHelper.Resolver(){

            @Override
            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return AbstractDockerMojo.this.imageConfigResolver.resolve(image, AbstractDockerMojo.this.project, AbstractDockerMojo.this.session);
            }
        }, this.filter, this);
        File topDockerfile = new File(this.project.getBasedir(), "Dockerfile");
        if (topDockerfile.exists()) {
            if (this.resolvedImages.isEmpty()) {
                this.resolvedImages.add(this.createSimpleDockerfileConfig(topDockerfile));
            } else if (this.resolvedImages.size() == 1 && this.resolvedImages.get(0).getBuildConfiguration() == null) {
                this.resolvedImages.set(0, this.addSimpleDockerfileConfig(this.resolvedImages.get(0), topDockerfile));
            }
        }
        return ConfigHelper.initAndValidate(this.resolvedImages, this.apiVersion, new ImageNameFormatter(this.project, buildTimeStamp), this.log);
    }

    @Override
    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> imageConfigs) {
        return imageConfigs;
    }

    protected boolean isDockerAccessRequired() {
        return Boolean.FALSE.equals(this.jib);
    }

    protected abstract void executeInternal(ServiceHub var1) throws IOException, ExecException, MojoExecutionException;

    protected List<ImageConfiguration> getResolvedImages() {
        return this.resolvedImages;
    }

    protected List<VolumeConfiguration> getVolumes() {
        return this.volumes;
    }

    public void contextualize(Context context) throws ContextException {
        this.authConfigFactory = new AuthConfigFactory((PlexusContainer)context.get((Object)"plexus"));
    }

    protected GavLabel getGavLabel() {
        return new GavLabel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    protected LogDispatcher getLogDispatcher(ServiceHub hub) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(hub.getDockerAccess());
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }

    private ImmutableList<ImageConfiguration> getAllImages() {
        ImmutableList.Builder allImages = ImmutableList.builder();
        if (this.images != null) {
            allImages.addAll(this.images);
        }
        if (this.imagesMap != null) {
            this.imagesMap.forEach((alias, config) -> {
                if (config.getAlias() == null) {
                    config.setAlias((String)alias);
                }
                allImages.add(config);
            });
        }
        return allImages.build();
    }

    public ImagePullManager getImagePullManager(String imagePullPolicy, String autoPull) {
        return new ImagePullManager(this.getSessionCacheStore(), imagePullPolicy, autoPull);
    }

    private ImagePullManager.CacheStore getSessionCacheStore() {
        return new ImagePullManager.CacheStore(){

            @Override
            public String get(String key) {
                Properties userProperties = AbstractDockerMojo.this.session.getUserProperties();
                return userProperties.getProperty(key);
            }

            @Override
            public void put(String key, String value) {
                Properties userProperties = AbstractDockerMojo.this.session.getUserProperties();
                userProperties.setProperty(key, value);
            }
        };
    }

    private ImageConfiguration createSimpleDockerfileConfig(File dockerFile) {
        String name = EnvUtil.getPropertiesWithSystemOverrides(this.project).getProperty("docker.name");
        if (name == null) {
            name = "%g/%a:%l";
        }
        BuildImageConfiguration buildConfig = new BuildImageConfiguration.Builder().dockerFile(dockerFile.getPath()).build();
        return new ImageConfiguration.Builder().name(name).buildConfig(buildConfig).build();
    }

    private ImageConfiguration addSimpleDockerfileConfig(ImageConfiguration image, File dockerfile) {
        BuildImageConfiguration buildConfig = new BuildImageConfiguration.Builder().dockerFile(dockerfile.getPath()).build();
        return new ImageConfiguration.Builder(image).buildConfig(buildConfig).build();
    }

    protected boolean invokedTogetherWithDockerStart() {
        Boolean startCalled = (Boolean)this.getPluginContext().get(CONTEXT_KEY_START_CALLED);
        return startCalled != null && startCalled != false;
    }

    protected Matcher getImageNameMatcher(String pattern, String configName) throws MojoExecutionException {
        try {
            String nameRegex = NamePatternUtil.convertNamePatternList(pattern, "image", true);
            if (nameRegex == null) {
                this.log.debug("No image name patterns in %s %s", configName, pattern);
                return null;
            }
            this.log.debug("Converted %s %s into image name regular expression %s", configName, pattern, nameRegex);
            return Pattern.compile(nameRegex).matcher("");
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected Matcher getContainerNameMatcher(String pattern, String configName) throws MojoExecutionException {
        try {
            String nameRegex = NamePatternUtil.convertNamePatternList(pattern, "name", true);
            if (nameRegex == null) {
                this.log.debug("No container name patterns in %s %s", configName, pattern);
                return null;
            }
            this.log.debug("Converted %s %s into container name regular expression %s", configName, pattern, nameRegex);
            return Pattern.compile(nameRegex).matcher("");
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected List<Container> getContainersForPattern(QueryService queryService, boolean all, Matcher imageNameMatcher, Matcher containerNameMatcher, String patternConfigName) throws IOException {
        return queryService.listContainers(all).stream().filter(c -> this.containerMatchesPattern((Container)c, imageNameMatcher, containerNameMatcher, patternConfigName)).collect(Collectors.toList());
    }

    protected void pullImage(RegistryService registryService, ImageConfiguration imageConfig, String pullRegistry) throws MojoExecutionException, DockerAccessException {
        String imageName = imageConfig.getName();
        RunImageConfiguration runConfiguration = imageConfig.getRunConfiguration();
        ImagePullManager pullManager = this.getImagePullManager(this.determinePullPolicy(runConfiguration), this.autoPull);
        RegistryService.RegistryConfig registryConfig = this.getRegistryConfig(pullRegistry);
        registryService.pullImageWithPolicy(imageName, pullManager, registryConfig, imageConfig.getBuildConfiguration());
    }

    protected boolean shouldSkipPom() {
        return this.skipPom && this.packaging.equalsIgnoreCase("pom");
    }

    private boolean containerMatchesPattern(Container container, Matcher imageNameMatcher, Matcher containerNameMatcher, String patternConfigName) {
        if (imageNameMatcher != null && container.getImage() != null && imageNameMatcher.reset(container.getImage()).find()) {
            this.log.debug("Container image %s matched %s", container.getImage(), patternConfigName);
            return true;
        }
        if (containerNameMatcher != null && container.getName() != null && containerNameMatcher.reset(container.getName()).find()) {
            this.log.debug("Container name %s matched %s", container.getName(), patternConfigName);
            return true;
        }
        this.log.debug("Neither container image %s nor name %s matched %s", container.getImage(), container.getName(), patternConfigName);
        return false;
    }

    private String determinePullPolicy(RunImageConfiguration runConfig) {
        return runConfig.getImagePullPolicy() != null ? runConfig.getImagePullPolicy() : this.imagePullPolicy;
    }

    protected ProjectPaths createProjectPaths() {
        return new ProjectPaths(this.project.getBasedir(), this.outputDirectory);
    }

    protected MojoParameters createMojoParameters() {
        return new MojoParameters(this.session, this.project, this.archive, this.mavenFileFilter, this.mavenFilterReader, this.settings, this.sourceDirectory, this.outputDirectory, this.reactorProjects);
    }
}

