/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.config.CopyConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.GavLabel;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="copy", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class CopyMojo
extends AbstractDockerMojo {
    private static final String COPY_NAME_PATTERN_CONFIG = "copyNamePattern";
    private static final String TEMP_ARCHIVE_FILE_PREFIX = "docker-copy-";
    private static final String TEMP_ARCHIVE_FILE_SUFFIX = ".tar";
    @Parameter(property="docker.createContainers", defaultValue="false")
    private boolean createContainers;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.containerNamePattern")
    private String containerNamePattern = "%n-%i";
    @Parameter(property="docker.copyAll", defaultValue="false")
    private boolean copyAll;

    @Override
    protected void executeInternal(ServiceHub hub) throws IOException, MojoExecutionException {
        DockerAccess dockerAccess = hub.getDockerAccess();
        RunService runService = hub.getRunService();
        ArchiveService archiveService = hub.getArchiveService();
        QueryService queryService = hub.getQueryService();
        GavLabel gavLabel = this.getGavLabel();
        if (this.createContainers) {
            RegistryService registryService = hub.getRegistryService();
            this.log.debug("Copy mojo is invoked standalone, copying from new temporary containers", new Object[0]);
            this.copyFromTemporaryContainers(dockerAccess, runService, registryService, archiveService, queryService, gavLabel);
        } else if (this.invokedTogetherWithDockerStart()) {
            this.log.debug("Copy mojo is invoked together with start mojo, copying from containers created by start mojo", new Object[0]);
            this.copyFromStartedContainers(dockerAccess, runService, archiveService, gavLabel);
        } else {
            this.log.debug("Copy mojo is invoked standalone, copying from existing containers", new Object[0]);
            this.copyFromExistingContainers(dockerAccess, archiveService, queryService);
        }
    }

    protected String getPullRegistry() {
        return this.pullRegistry;
    }

    private void copyFromTemporaryContainers(DockerAccess dockerAccess, RunService runService, RegistryService registryService, ArchiveService archiveService, QueryService queryService, GavLabel gavLabel) throws IOException, MojoExecutionException {
        List<ImageConfiguration> imageConfigurations = this.getResolvedImages();
        for (ImageConfiguration imageConfiguration : imageConfigurations) {
            CopyConfiguration copyConfiguration = imageConfiguration.getCopyConfiguration();
            String imageName = imageConfiguration.getName();
            if (this.isEmpty(copyConfiguration)) {
                this.log.debug("Copy configuration is not defined for %s image, skipping coping", imageName);
                continue;
            }
            try (ContainerRemover containerRemover = new ContainerRemover(this.log, runService, this.removeVolumes);){
                String containerId = this.createContainer(runService, registryService, imageConfiguration, gavLabel);
                containerRemover.setContainerId(containerId);
                this.log.debug("Created %s container from %s image", containerId, imageName);
                this.copy(dockerAccess, archiveService, containerId, imageName, copyConfiguration);
            }
        }
    }

    private void copyFromStartedContainers(DockerAccess dockerAccess, RunService runService, ArchiveService archiveService, GavLabel gavLabel) throws IOException, MojoExecutionException {
        List<RunService.ContainerDescriptor> containerDescriptors = runService.getContainers(gavLabel);
        for (RunService.ContainerDescriptor containerDescriptor : containerDescriptors) {
            ImageConfiguration imageConfiguration = containerDescriptor.getImageConfig();
            CopyConfiguration copyConfiguration = imageConfiguration.getCopyConfiguration();
            String imageName = imageConfiguration.getName();
            if (this.isEmpty(copyConfiguration)) {
                this.log.debug("Copy configuration is not defined for %s image, skipping coping", imageName);
                continue;
            }
            String containerId = containerDescriptor.getContainerId();
            this.log.debug("Found %s container of %s image started by start mojo", containerId, imageName);
            this.copy(dockerAccess, archiveService, containerId, imageName, copyConfiguration);
        }
    }

    private void copyFromExistingContainers(DockerAccess dockerAccess, ArchiveService archiveService, QueryService queryService) throws IOException, MojoExecutionException {
        List<ImageConfiguration> imageConfigurations = this.getResolvedImages();
        for (ImageConfiguration imageConfiguration : imageConfigurations) {
            CopyConfiguration copyConfiguration = imageConfiguration.getCopyConfiguration();
            String imageName = imageConfiguration.getName();
            if (this.isEmpty(copyConfiguration)) {
                this.log.debug("Copy configuration is not defined for %s image, skipping coping", imageName);
                continue;
            }
            List<Container> containers = this.getContainersForImage(queryService, imageConfiguration);
            if (containers.isEmpty()) {
                this.log.warn("Found no containers of %s image", imageName);
                continue;
            }
            if (containers.size() > 1) {
                this.log.warn("Found more than one container of %s image", imageName);
            }
            for (Container container : containers) {
                String containerId = container.getId();
                this.log.debug("Found %s container of %s image", containerId, imageName);
                this.copy(dockerAccess, archiveService, containerId, imageName, copyConfiguration);
            }
        }
    }

    private boolean isEmpty(CopyConfiguration copyConfiguration) {
        if (copyConfiguration == null) {
            return true;
        }
        List<CopyConfiguration.Entry> copyEntries = copyConfiguration.getEntries();
        return copyEntries == null || copyEntries.isEmpty();
    }

    private List<Container> getContainersForImage(QueryService queryService, ImageConfiguration imageConfiguration) throws IOException, MojoExecutionException {
        Container latestContainer;
        Matcher containerNameMatcher;
        String imageName = imageConfiguration.getName();
        String copyNamePattern = imageConfiguration.getCopyNamePattern();
        Matcher matcher = containerNameMatcher = copyNamePattern == null ? null : this.getContainerNameMatcher(copyNamePattern, COPY_NAME_PATTERN_CONFIG);
        if (this.copyAll) {
            if (containerNameMatcher == null) {
                return queryService.getContainersForImage(imageName, true);
            }
            return this.getContainersForPattern(queryService, true, null, containerNameMatcher, COPY_NAME_PATTERN_CONFIG);
        }
        if (containerNameMatcher == null) {
            latestContainer = queryService.getLatestContainerForImage(imageName, true);
        } else {
            List<Container> matchingContainers = this.getContainersForPattern(queryService, true, null, containerNameMatcher, COPY_NAME_PATTERN_CONFIG);
            latestContainer = queryService.getLatestContainer(matchingContainers);
        }
        return latestContainer == null ? Collections.emptyList() : Collections.singletonList(latestContainer);
    }

    private String createContainer(RunService runService, RegistryService registryService, ImageConfiguration imageConfiguration, GavLabel gavLabel) throws IOException, MojoExecutionException {
        Properties projectProperties = this.project.getProperties();
        this.pullImage(registryService, imageConfiguration, this.pullRegistry);
        return runService.createContainer(imageConfiguration, runService.createPortMapping(imageConfiguration.getRunConfiguration(), projectProperties), gavLabel, projectProperties, this.project.getBasedir(), this.containerNamePattern, this.getBuildTimestamp());
    }

    private void copy(DockerAccess dockerAccess, ArchiveService archiveService, String containerId, String imageName, CopyConfiguration copyConfiguration) throws IOException, MojoExecutionException {
        List<CopyConfiguration.Entry> copyEntries = copyConfiguration.getEntries();
        for (CopyConfiguration.Entry copyEntry : copyEntries) {
            String containerPath = copyEntry.getContainerPath();
            if (containerPath == null) {
                this.log.error("containerPath of copy goal entry for %s image is not specified", imageName);
                throw new IllegalArgumentException("containerPath should be specified");
            }
            File hostDirectory = this.getHostDirectory(copyEntry.getHostDirectory());
            this.log.info("Copying %s from %s container into %s host directory", containerPath, containerId, hostDirectory.getAbsolutePath());
            Files.createDirectories(hostDirectory.toPath(), new FileAttribute[0]);
            try (FileRemover fileRemover = new FileRemover(this.log);){
                File archiveFile = Files.createTempFile(TEMP_ARCHIVE_FILE_PREFIX, TEMP_ARCHIVE_FILE_SUFFIX, new FileAttribute[0]).toFile();
                fileRemover.setFile(archiveFile);
                this.log.debug("Created %s temporary file for docker copy archive", archiveFile);
                this.log.debug("Copying %s from %s container into %s host file", containerPath, containerId, archiveFile);
                dockerAccess.copyArchiveFromContainer(containerId, containerPath, archiveFile);
                this.log.debug("Extracting %s archive into %s directory", archiveFile, hostDirectory);
                archiveService.extractDockerCopyArchive(archiveFile, hostDirectory);
            }
        }
    }

    private File getHostDirectory(String hostPath) {
        File projectBaseDirectory = this.project.getBasedir();
        if (hostPath == null) {
            return projectBaseDirectory;
        }
        File hostDirectory = new File(hostPath);
        if (hostDirectory.isAbsolute()) {
            return hostDirectory;
        }
        return new File(projectBaseDirectory, hostPath);
    }

    private static class FileRemover
    implements AutoCloseable {
        private final Logger logger;
        private File file;

        public FileRemover(Logger logger) {
            this.logger = logger;
        }

        public void setFile(File file) {
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            if (this.file != null) {
                this.logger.debug("Removing %s file", this.file);
                Files.delete(this.file.toPath());
                this.file = null;
            }
        }
    }

    private static class ContainerRemover
    implements AutoCloseable {
        private final Logger logger;
        private final RunService runService;
        private final boolean removeVolumes;
        private String containerId;

        public ContainerRemover(Logger logger, RunService runService, boolean removeVolumes) {
            this.logger = logger;
            this.runService = runService;
            this.removeVolumes = removeVolumes;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        @Override
        public void close() throws IOException {
            if (this.containerId != null) {
                this.logger.debug("Removing %s container", this.containerId);
                this.runService.removeContainer(this.containerId, this.removeVolumes);
                this.containerId = null;
            }
        }
    }
}

