/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.assembly.DockerAssemblyConfigurationSource;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugins.assembly.io.DefaultAssemblyReader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.yaml.snakeyaml.Yaml;

public class DockerFileUtil {
    private static final String ARG_PATTERN_REGEX = "\\$(?:\\{(.*)\\}|(.*))";

    private DockerFileUtil() {
    }

    public static List<String> extractBaseImages(File dockerFile, FixedStringSearchInterpolator interpolator, Map<String, String> argsFromBuildConfig) throws IOException {
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", interpolator);
        Map<String, String> args = DockerFileUtil.extractArgs(dockerFile, argsFromBuildConfig, interpolator);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> fromAlias = new HashSet<String>();
        for (String[] fromLine : fromLines) {
            if (fromLine.length <= 1) continue;
            if (!fromAlias.contains(fromLine[1])) {
                result.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[1], args));
            }
            if (fromLine.length != 4) continue;
            fromAlias.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[3], args));
        }
        return new ArrayList<String>(result);
    }

    public static Map<String, String> extractArgs(File dockerfile, Map<String, String> argsFromBuildConfig, FixedStringSearchInterpolator interpolator) throws IOException {
        return DockerFileUtil.extractArgsFromLines(DockerFileUtil.extractLines(dockerfile, "ARG", interpolator), argsFromBuildConfig);
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, FixedStringSearchInterpolator interpolator) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = interpolator.interpolate(line);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, FixedStringSearchInterpolator interpolator) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(interpolator.interpolate(line)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    public static FixedStringSearchInterpolator createInterpolator(MojoParameters params, String filter) {
        String[] delimiters = DockerFileUtil.extractDelimiters(filter);
        if (delimiters == null) {
            return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[0]);
        }
        DockerAssemblyConfigurationSource configSource = new DockerAssemblyConfigurationSource(params, null, null);
        return AssemblyInterpolator.fullInterpolator((MavenProject)params.getProject(), (FixedStringSearchInterpolator)DefaultAssemblyReader.createProjectInterpolator((MavenProject)params.getProject()).withExpressionMarkers(delimiters[0], delimiters[1]), (AssemblerConfigurationSource)configSource).withExpressionMarkers(delimiters[0], delimiters[1]);
    }

    static Map<String, String> extractArgsFromLines(List<String[]> argLines, Map<String, String> argsFromBuildConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] argLine : argLines) {
            if (argLine.length <= 1) continue;
            DockerFileUtil.updateMapWithArgValue(result, argsFromBuildConfig, argLine[1]);
        }
        return result;
    }

    static String resolveArgValueFromStrContainingArgKey(String argString, Map<String, String> args) {
        Pattern argPattern = Pattern.compile(ARG_PATTERN_REGEX);
        Matcher matcher = argPattern.matcher(argString);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                return args.get(matcher.group(1));
            }
            if (matcher.group(2) != null) {
                return args.get(matcher.group(2));
            }
        }
        return null;
    }

    private static String resolveImageTagFromArgs(String imageTagString, Map<String, String> args) {
        if (imageTagString.startsWith("$")) {
            String resolvedVal = DockerFileUtil.resolveArgValueFromStrContainingArgKey(imageTagString, args);
            if (resolvedVal != null) {
                return resolvedVal;
            }
        } else {
            String tag;
            String[] imageTagArr = imageTagString.split(":");
            if (imageTagArr.length > 1 && (tag = DockerFileUtil.resolveArgValueFromStrContainingArgKey(imageTagArr[1], args)) != null) {
                return imageTagArr[0] + ":" + tag;
            }
        }
        return imageTagString;
    }

    private static Reader getFileReaderFromDir(File file) {
        if (file.exists() && file.length() != 0L) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find " + file, e);
            }
        }
        return null;
    }

    public static JsonObject readDockerConfig() {
        String dockerConfig = System.getenv("DOCKER_CONFIG");
        Reader reader = dockerConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".docker/config.json")) : DockerFileUtil.getFileReaderFromDir(new File(dockerConfig, "config.json"));
        return reader != null ? (JsonObject)new Gson().fromJson(reader, JsonObject.class) : null;
    }

    public static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return null;
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }

    public static Map<String, ?> readKubeConfig() {
        Reader reader;
        String kubeConfig = System.getenv("KUBECONFIG");
        Reader reader2 = reader = kubeConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".kube/config")) : DockerFileUtil.getFileReaderFromDir(new File(kubeConfig));
        if (reader != null) {
            Yaml ret = new Yaml();
            return (Map)ret.load(reader);
        }
        return null;
    }

    private static File getHomeDir() {
        return new File(EnvUtil.getUserHome());
    }

    private static void updateMapWithArgValue(Map<String, String> result, Map<String, String> args, String argString) {
        if (argString.contains("=") || argString.contains(":")) {
            String[] argStringParts = argString.split("[=:]");
            String argStringValue = argString.substring(argStringParts[0].length() + 1);
            if (argStringValue.startsWith("\"") || argStringValue.startsWith("'")) {
                argStringValue = argStringValue.replaceAll("^\"|\"|'|'$", "");
            } else {
                DockerFileUtil.validateArgValue(argStringValue);
            }
            result.put(argStringParts[0], argStringValue);
        } else {
            DockerFileUtil.validateArgValue(argString);
            result.putAll(DockerFileUtil.fetchArgsFromBuildConfiguration(argString, args));
        }
    }

    private static Map<String, String> fetchArgsFromBuildConfiguration(String argString, Map<String, String> args) {
        HashMap<String, String> argFromBuildConfig = new HashMap<String, String>();
        if (args != null) {
            argFromBuildConfig.put(argString, args.getOrDefault(argString, ""));
        }
        return argFromBuildConfig;
    }

    private static void validateArgValue(String argStringParam) {
        String[] argStringParts = argStringParam.split("\\s+");
        if (argStringParts.length > 1) {
            throw new IllegalArgumentException("Dockerfile parse error: ARG requires exactly one argument. Provided : " + argStringParam);
        }
    }
}

