/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Repository;
import io.fabric8.camelk.v1.RepositoryFluent;
import io.fabric8.camelk.v1.RepositoryPolicy;
import io.fabric8.camelk.v1.RepositoryPolicyBuilder;
import io.fabric8.camelk.v1.RepositoryPolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class RepositoryFluentImpl<A extends RepositoryFluent<A>>
extends BaseFluent<A>
implements RepositoryFluent<A> {
    private String id;
    private String name;
    private RepositoryPolicyBuilder releases;
    private RepositoryPolicyBuilder snapshots;
    private String url;

    public RepositoryFluentImpl() {
    }

    public RepositoryFluentImpl(Repository instance) {
        if (instance != null) {
            this.withId(instance.getId());
            this.withName(instance.getName());
            this.withReleases(instance.getReleases());
            this.withSnapshots(instance.getSnapshots());
            this.withUrl(instance.getUrl());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public RepositoryPolicy getReleases() {
        return this.releases != null ? this.releases.build() : null;
    }

    @Override
    public RepositoryPolicy buildReleases() {
        return this.releases != null ? this.releases.build() : null;
    }

    @Override
    public A withReleases(RepositoryPolicy releases) {
        this._visitables.get((Object)"releases").remove(this.releases);
        if (releases != null) {
            this.releases = new RepositoryPolicyBuilder(releases);
            this._visitables.get((Object)"releases").add(this.releases);
        } else {
            this.releases = null;
            this._visitables.get((Object)"releases").remove(this.releases);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReleases() {
        return this.releases != null;
    }

    @Override
    public A withNewReleases(String checksumPolicy, Boolean enabled, String updatePolicy) {
        return this.withReleases(new RepositoryPolicy(checksumPolicy, enabled, updatePolicy));
    }

    @Override
    public RepositoryFluent.ReleasesNested<A> withNewReleases() {
        return new ReleasesNestedImpl();
    }

    @Override
    public RepositoryFluent.ReleasesNested<A> withNewReleasesLike(RepositoryPolicy item) {
        return new ReleasesNestedImpl(item);
    }

    @Override
    public RepositoryFluent.ReleasesNested<A> editReleases() {
        return this.withNewReleasesLike(this.getReleases());
    }

    @Override
    public RepositoryFluent.ReleasesNested<A> editOrNewReleases() {
        return this.withNewReleasesLike(this.getReleases() != null ? this.getReleases() : new RepositoryPolicyBuilder().build());
    }

    @Override
    public RepositoryFluent.ReleasesNested<A> editOrNewReleasesLike(RepositoryPolicy item) {
        return this.withNewReleasesLike(this.getReleases() != null ? this.getReleases() : item);
    }

    @Override
    @Deprecated
    public RepositoryPolicy getSnapshots() {
        return this.snapshots != null ? this.snapshots.build() : null;
    }

    @Override
    public RepositoryPolicy buildSnapshots() {
        return this.snapshots != null ? this.snapshots.build() : null;
    }

    @Override
    public A withSnapshots(RepositoryPolicy snapshots) {
        this._visitables.get((Object)"snapshots").remove(this.snapshots);
        if (snapshots != null) {
            this.snapshots = new RepositoryPolicyBuilder(snapshots);
            this._visitables.get((Object)"snapshots").add(this.snapshots);
        } else {
            this.snapshots = null;
            this._visitables.get((Object)"snapshots").remove(this.snapshots);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSnapshots() {
        return this.snapshots != null;
    }

    @Override
    public A withNewSnapshots(String checksumPolicy, Boolean enabled, String updatePolicy) {
        return this.withSnapshots(new RepositoryPolicy(checksumPolicy, enabled, updatePolicy));
    }

    @Override
    public RepositoryFluent.SnapshotsNested<A> withNewSnapshots() {
        return new SnapshotsNestedImpl();
    }

    @Override
    public RepositoryFluent.SnapshotsNested<A> withNewSnapshotsLike(RepositoryPolicy item) {
        return new SnapshotsNestedImpl(item);
    }

    @Override
    public RepositoryFluent.SnapshotsNested<A> editSnapshots() {
        return this.withNewSnapshotsLike(this.getSnapshots());
    }

    @Override
    public RepositoryFluent.SnapshotsNested<A> editOrNewSnapshots() {
        return this.withNewSnapshotsLike(this.getSnapshots() != null ? this.getSnapshots() : new RepositoryPolicyBuilder().build());
    }

    @Override
    public RepositoryFluent.SnapshotsNested<A> editOrNewSnapshotsLike(RepositoryPolicy item) {
        return this.withNewSnapshotsLike(this.getSnapshots() != null ? this.getSnapshots() : item);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryFluentImpl that = (RepositoryFluentImpl)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.releases, that.releases)) {
            return false;
        }
        if (!Objects.equals(this.snapshots, that.snapshots)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.releases, this.snapshots, this.url, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.releases != null) {
            sb.append("releases:");
            sb.append(this.releases + ",");
        }
        if (this.snapshots != null) {
            sb.append("snapshots:");
            sb.append(this.snapshots + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    class SnapshotsNestedImpl<N>
    extends RepositoryPolicyFluentImpl<RepositoryFluent.SnapshotsNested<N>>
    implements RepositoryFluent.SnapshotsNested<N>,
    Nested<N> {
        RepositoryPolicyBuilder builder;

        SnapshotsNestedImpl(RepositoryPolicy item) {
            this.builder = new RepositoryPolicyBuilder(this, item);
        }

        SnapshotsNestedImpl() {
            this.builder = new RepositoryPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)RepositoryFluentImpl.this.withSnapshots(this.builder.build());
        }

        @Override
        public N endSnapshots() {
            return this.and();
        }
    }

    class ReleasesNestedImpl<N>
    extends RepositoryPolicyFluentImpl<RepositoryFluent.ReleasesNested<N>>
    implements RepositoryFluent.ReleasesNested<N>,
    Nested<N> {
        RepositoryPolicyBuilder builder;

        ReleasesNestedImpl(RepositoryPolicy item) {
            this.builder = new RepositoryPolicyBuilder(this, item);
        }

        ReleasesNestedImpl() {
            this.builder = new RepositoryPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)RepositoryFluentImpl.this.withReleases(this.builder.build());
        }

        @Override
        public N endReleases() {
            return this.and();
        }
    }
}

