/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.templates;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/oapi/v1/namespaces/{namespace}")
@Produces(value={"application/json", "text/xml"})
@Consumes(value={"application/json", "text/xml"})
@Singleton
public class TemplatesService {
    private static final Logger LOG = LoggerFactory.getLogger(TemplatesService.class);
    private String dataFolder = Systems.getEnvVar((String)"DATA_DIR", (String)".data");

    public TemplatesService() {
        System.out.println("Starting TemplateService using dataFolder " + this.dataFolder);
        LOG.info("Starting TemplateService using dataFolder " + this.dataFolder);
    }

    @POST
    @Path(value="processedtemplates")
    @Consumes(value={"application/json", "application/yaml"})
    public String processTemplate(@PathParam(value="namespace") String namespace, Template entity) throws Exception {
        KubernetesList list = Templates.processTemplatesLocally((Template)entity, (boolean)false);
        return KubernetesHelper.toJson((Object)list);
    }

    @GET
    @Path(value="templates")
    public Object getTemplates(@PathParam(value="namespace") String namespace, @QueryParam(value="watch") String watchFlag, @HeaderParam(value="Sec-WebSocket-Key") String reqid) {
        if (watchFlag == null || watchFlag.equals("true")) {
            // empty if block
        }
        List<Template> items = this.getResourceList(namespace, Template.class);
        TemplateList answer = new TemplateList();
        answer.setItems(items);
        return answer;
    }

    @Path(value="templates")
    @POST
    @Consumes(value={"application/json", "application/yaml"})
    public void createTemplate(@PathParam(value="namespace") String namespace, Template entity) throws Exception {
        String name = KubernetesHelper.getName((HasMetadata)entity);
        this.updateNamed(namespace, name, entity);
    }

    @GET
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    public Template getTemplate(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name) {
        return this.findNamed(this.getResourceList(namespace, Template.class), name);
    }

    @PUT
    @Path(value="templates/{name}")
    @Consumes(value={"application/json", "application/yaml"})
    public void updateTemplate(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name, Template entity) throws IOException {
        this.updateNamed(namespace, name, entity);
    }

    @DELETE
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public void deleteTemplate(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name) {
        this.deleteNamed(namespace, name, Template.class);
    }

    @GET
    @Path(value="buildconfigs")
    public BuildConfigList getBuildConfigs(@PathParam(value="namespace") String namespace) {
        List<BuildConfig> items = this.getResourceList(namespace, BuildConfig.class);
        BuildConfigList answer = new BuildConfigList();
        answer.setItems(items);
        return answer;
    }

    @Path(value="buildconfigs")
    @POST
    @Consumes(value={"application/json", "application/yaml"})
    public void createBuildConfig(@PathParam(value="namespace") String namespace, BuildConfig entity) throws Exception {
        String name = KubernetesHelper.getName((HasMetadata)entity);
        this.updateNamed(namespace, name, entity);
    }

    @GET
    @Path(value="buildconfigs/{name}")
    @Produces(value={"application/json"})
    public BuildConfig getBuildConfig(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name) {
        return this.findNamed(this.getResourceList(namespace, BuildConfig.class), name);
    }

    @PUT
    @Path(value="buildconfigs/{name}")
    @Consumes(value={"application/json", "application/yaml"})
    public void updateBuildConfig(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name, BuildConfig entity) throws IOException {
        this.updateNamed(namespace, name, entity);
    }

    @DELETE
    @Path(value="buildconfigs/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public void deleteBuildConfig(@PathParam(value="namespace") String namespace, @PathParam(value="name") @NotNull String name) {
        this.deleteNamed(namespace, name, BuildConfig.class);
    }

    protected <T extends HasMetadata> T findNamed(List<T> items, String name) {
        for (HasMetadata item : items) {
            String aName;
            ObjectMeta metadata = item.getMetadata();
            if (metadata == null || !Objects.equal((Object)name, (Object)(aName = metadata.getName()))) continue;
            return (T)item;
        }
        return null;
    }

    protected <T extends HasMetadata> List<T> getResourceList(@PathParam(value="namespace") String namespace, Class<T> clazz) {
        File folder = this.getResourceCollectionFolder(namespace, clazz);
        return this.loadFiles(folder, clazz);
    }

    protected <T extends HasMetadata> List<T> loadFiles(File folder, Class<T> clazz) {
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (!file.isFile() || !name.endsWith(".json")) continue;
                Object value = null;
                try {
                    value = KubernetesHelper.loadJson((File)file);
                }
                catch (IOException e) {
                    LOG.warn("Failed to load JSON file " + file + ". " + e, (Throwable)e);
                }
                if (value == null) continue;
                if (clazz.isInstance(value)) {
                    HasMetadata cast = (HasMetadata)clazz.cast(value);
                    answer.add(cast);
                    continue;
                }
                LOG.warn("Ignoring instance " + value + " of type " + value.getClass().getName() + " when expecting instance of " + clazz.getName() + " from file " + file);
            }
        }
        return answer;
    }

    protected void deleteNamed(String namespace, String name, Class<? extends HasMetadata> clazz) {
        File entityFile = this.getResourceFile(namespace, name, clazz);
        if (entityFile == null || !entityFile.exists()) {
            throw new WebApplicationException("No such entity", Response.Status.NOT_FOUND);
        }
        entityFile.delete();
    }

    protected File getResourceFile(String namespace, String name, Class<? extends HasMetadata> clazz) {
        if (Strings.isNullOrBlank((String)name)) {
            return null;
        }
        File folder = this.getResourceCollectionFolder(namespace, clazz);
        return new File(folder, name + ".json");
    }

    protected <T extends HasMetadata> void updateNamed(String namespace, String name, T entity) throws IOException {
        File entityFile = this.getResourceFile(namespace, name, entity.getClass());
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        metadata.setNamespace(namespace);
        metadata.setName(name);
        if (entityFile == null) {
            throw new WebApplicationException("No metadata.name supplied!");
        }
        KubernetesHelper.saveJson((File)entityFile, entity);
    }

    private File getResourceCollectionFolder(String namespace, Class<? extends HasMetadata> clazz) {
        String path = clazz.getSimpleName().toLowerCase();
        File data = new File(this.dataFolder);
        File namespaceFolder = new File(data, namespace);
        File answer = new File(namespaceFolder, path);
        answer.mkdirs();
        return answer;
    }
}

