/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import java.util.Properties;

public class OracleConfig
extends DbConfig {
    private String apexPort = "8181";
    private String internalApexPort = "8080";
    private int startupWaitMinutes = 8;

    public OracleConfig(String version, Properties properties) {
        this(version);
        this.setProperties(properties);
    }

    public OracleConfig() {
        this("latest");
    }

    public OracleConfig(String version) {
        super("oracle", 1521, 1521, version);
        this.image = "vitorfec/oracle-xe-18c:" + version;
        this.setAdminUser("system");
        this.setAdminPassword("oracle");
        this.setDbName("XE");
    }

    @Override
    public String jdbcUrl() {
        return "jdbc:oracle:thin:@localhost:" + this.getPort() + ":" + this.getDbName();
    }

    public String getApexPort() {
        return this.apexPort;
    }

    public void setApexPort(String apexPort) {
        this.apexPort = apexPort;
    }

    public String getInternalApexPort() {
        return this.internalApexPort;
    }

    public void setInternalApexPort(String internalApexPort) {
        this.internalApexPort = internalApexPort;
    }

    public int getStartupWaitMinutes() {
        return this.startupWaitMinutes;
    }

    public void setStartupWaitMinutes(int startupWaitMinutes) {
        this.startupWaitMinutes = startupWaitMinutes;
    }
}

