/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.ClickHouseConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class ClickHouseContainer
extends JdbcBaseDbContainer {
    public static ClickHouseContainer create(String version, Properties properties) {
        return new ClickHouseContainer(new ClickHouseConfig(version, properties));
    }

    ClickHouseContainer(ClickHouseConfig config) {
        super(config);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabase(connection);
            }
            this.createDatabase(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void dropDatabase(Connection connection) {
        this.sqlRun(connection, "drop database if exists " + this.dbConfig.getDbName());
    }

    private void createDatabase(Connection connection) {
        this.sqlRun(connection, "create database if not exists " + this.dbConfig.getDbName());
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("--ulimit");
        args.add("nofile=262144:262144");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add(this.config.getImage());
        ProcessBuilder pb = this.createProcessBuilder(args);
        pb.redirectErrorStream(true);
        return pb;
    }
}

