/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.runner.MigrationMetaRow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MigrationPlatform {
    private static final String BASE_SELECT = "select id, mtype, mstatus, mversion, mcomment, mchecksum, run_on, run_by, run_time from ";
    String forUpdateSuffix = " order by id for update";

    void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.selectSql(sqlTable);
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
        }
    }

    List<MigrationMetaRow> readExistingMigrations(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.selectSql(sqlTable);
        ArrayList<MigrationMetaRow> rows = new ArrayList<MigrationMetaRow>();
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                rows.add(new MigrationMetaRow(resultSet));
            }
        }
        return rows;
    }

    String selectSql(String table) {
        return BASE_SELECT + table + this.forUpdateSuffix;
    }

    public static class NoLocking
    extends MigrationPlatform {
        public NoLocking() {
            this.forUpdateSuffix = " order by id";
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) {
        }
    }

    public static class SqlServer
    extends MigrationPlatform {
        public SqlServer() {
            this.forUpdateSuffix = " with (updlock) order by id";
        }
    }

    public static class Postgres
    extends MigrationPlatform {
        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            try (PreparedStatement query = connection.prepareStatement("lock table " + sqlTable);){
                query.execute();
            }
        }
    }
}

