/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.ConfigurationAware;
import io.ebean.migration.JdbcMigration;
import io.ebean.migration.JdbcMigrationFactory;
import io.ebean.migration.MigrationException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MigrationConfig {
    private String migrationPath = "dbmigration";
    private String migrationInitPath = "dbinit";
    private String metaTable = "db_migration";
    private String applySuffix = ".sql";
    private String runPlaceholders;
    private boolean skipChecksum;
    private Map<String, String> runPlaceholderMap;
    private ClassLoader classLoader;
    private String dbUsername;
    private String dbPassword;
    private String dbDriver;
    private String dbUrl;
    private String dbSchema;
    private boolean createSchemaIfNotExists = true;
    private boolean setCurrentSchema = true;
    private boolean allowErrorInRepeatable;
    private String platformName;
    private JdbcMigrationFactory jdbcMigrationFactory = new DefaultMigrationFactory();
    private Set<String> patchInsertOn;
    private Set<String> patchResetChecksumOn;

    public String getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(String metaTable) {
        this.metaTable = metaTable;
    }

    private Set<String> parseCommaDelimited(String versionsCommaDelimited) {
        if (versionsCommaDelimited != null) {
            String[] split;
            HashSet<String> versions = new HashSet<String>();
            for (String version : split = versionsCommaDelimited.split(",")) {
                if (version.startsWith("R__")) {
                    version = version.substring(3);
                }
                versions.add(version);
            }
            return versions;
        }
        return null;
    }

    public boolean isAllowErrorInRepeatable() {
        return this.allowErrorInRepeatable;
    }

    public void setAllowErrorInRepeatable(boolean allowErrorInRepeatable) {
        this.allowErrorInRepeatable = allowErrorInRepeatable;
    }

    public void setPatchResetChecksumOn(String versionsCommaDelimited) {
        this.patchResetChecksumOn = this.parseCommaDelimited(versionsCommaDelimited);
    }

    public void setPatchResetChecksumOn(Set<String> patchResetChecksumOn) {
        this.patchResetChecksumOn = patchResetChecksumOn;
    }

    public Set<String> getPatchResetChecksumOn() {
        return this.patchResetChecksumOn;
    }

    public void setPatchInsertOn(String versionsCommaDelimited) {
        this.patchInsertOn = this.parseCommaDelimited(versionsCommaDelimited);
    }

    public void setPatchInsertOn(Set<String> patchInsertOn) {
        this.patchInsertOn = patchInsertOn;
    }

    public Set<String> getPatchInsertOn() {
        return this.patchInsertOn;
    }

    public boolean isSkipChecksum() {
        return this.skipChecksum;
    }

    public void setSkipChecksum(boolean skipChecksum) {
        this.skipChecksum = skipChecksum;
    }

    public String getRunPlaceholders() {
        return this.runPlaceholders;
    }

    public void setRunPlaceholders(String runPlaceholders) {
        this.runPlaceholders = runPlaceholders;
    }

    public Map<String, String> getRunPlaceholderMap() {
        return this.runPlaceholderMap;
    }

    public void setRunPlaceholderMap(Map<String, String> runPlaceholderMap) {
        this.runPlaceholderMap = runPlaceholderMap;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    public String getMigrationInitPath() {
        return this.migrationInitPath;
    }

    public void setMigrationInitPath(String migrationInitPath) {
        this.migrationInitPath = migrationInitPath;
    }

    public String getApplySuffix() {
        return this.applySuffix;
    }

    public void setApplySuffix(String applySuffix) {
        this.applySuffix = applySuffix;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public boolean isCreateSchemaIfNotExists() {
        return this.createSchemaIfNotExists;
    }

    public void setCreateSchemaIfNotExists(boolean createSchemaIfNotExists) {
        this.createSchemaIfNotExists = createSchemaIfNotExists;
    }

    public boolean isSetCurrentSchema() {
        return this.setCurrentSchema;
    }

    public void setSetCurrentSchema(boolean setCurrentSchema) {
        this.setCurrentSchema = setCurrentSchema;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JdbcMigrationFactory getJdbcMigrationFactory() {
        return this.jdbcMigrationFactory;
    }

    public void setJdbcMigrationFactory(JdbcMigrationFactory jdbcMigrationFactory) {
        this.jdbcMigrationFactory = jdbcMigrationFactory;
    }

    public void load(Properties props) {
        String runPlaceholders;
        String patchResetChecksumOn;
        String setSchema;
        String createSchema;
        this.dbUsername = props.getProperty("dbmigration.username", this.dbUsername);
        this.dbPassword = props.getProperty("dbmigration.password", this.dbPassword);
        this.dbDriver = props.getProperty("dbmigration.driver", this.dbDriver);
        this.dbUrl = props.getProperty("dbmigration.url", this.dbUrl);
        this.dbSchema = props.getProperty("dbmigration.schema", this.dbSchema);
        String skip = props.getProperty("dbmigration.skipchecksum");
        if (skip != null) {
            this.skipChecksum = Boolean.parseBoolean(skip);
        }
        if ((createSchema = props.getProperty("dbmigration.createSchemaIfNotExists")) != null) {
            this.createSchemaIfNotExists = Boolean.parseBoolean(createSchema);
        }
        if ((setSchema = props.getProperty("dbmigration.setCurrentSchema")) != null) {
            this.setCurrentSchema = Boolean.parseBoolean(setSchema);
        }
        this.platformName = props.getProperty("dbmigration.platformName", this.platformName);
        this.applySuffix = props.getProperty("dbmigration.applySuffix", this.applySuffix);
        this.metaTable = props.getProperty("dbmigration.metaTable", this.metaTable);
        this.migrationPath = props.getProperty("dbmigration.migrationPath", this.migrationPath);
        this.migrationInitPath = props.getProperty("dbmigration.migrationInitPath", this.migrationInitPath);
        this.runPlaceholders = props.getProperty("dbmigration.placeholders", this.runPlaceholders);
        String patchInsertOn = props.getProperty("dbmigration.patchInsertOn");
        if (patchInsertOn != null) {
            this.setPatchInsertOn(patchInsertOn);
        }
        if ((patchResetChecksumOn = props.getProperty("dbmigration.patchResetChecksumOn")) != null) {
            this.setPatchResetChecksumOn(patchResetChecksumOn);
        }
        if ((runPlaceholders = props.getProperty("dbmigration.runPlaceholders")) != null) {
            this.setRunPlaceholders(runPlaceholders);
        }
    }

    public Connection createConnection() {
        if (this.dbUsername == null) {
            throw new MigrationException("Database username is null?");
        }
        if (this.dbPassword == null) {
            throw new MigrationException("Database password is null?");
        }
        if (this.dbDriver == null) {
            throw new MigrationException("Database Driver is null?");
        }
        if (this.dbUrl == null) {
            throw new MigrationException("Database connection URL is null?");
        }
        this.loadDriver();
        try {
            Properties props = new Properties();
            props.setProperty("user", this.dbUsername);
            props.setProperty("password", this.dbPassword);
            return DriverManager.getConnection(this.dbUrl, props);
        }
        catch (SQLException e) {
            throw new MigrationException("Error trying to create Connection", e);
        }
    }

    private void loadDriver() {
        try {
            Class.forName(this.dbDriver, true, this.getClassLoader());
        }
        catch (Throwable e) {
            throw new MigrationException("Problem loading Database Driver [" + this.dbDriver + "]: " + e.getMessage(), e);
        }
    }

    public class DefaultMigrationFactory
    implements JdbcMigrationFactory {
        @Override
        public JdbcMigration createInstance(String className) {
            try {
                Class<?> clazz = Class.forName(className, true, MigrationConfig.this.getClassLoader());
                JdbcMigration migration = (JdbcMigration)clazz.newInstance();
                if (migration instanceof ConfigurationAware) {
                    ((ConfigurationAware)((Object)migration)).setMigrationConfig(MigrationConfig.this);
                }
                return migration;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(className + " is not a valid JdbcMigration", e);
            }
        }
    }
}

