/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.mapping;

import io.ebean.annotation.DocMapping;
import io.ebean.annotation.DocProperty;

public class DocPropertyOptions {
    private Boolean code;
    private Boolean sortable;
    private Boolean store;
    private Float boost;
    private String nullValue;
    private Boolean includeInAll;
    private Boolean enabled;
    private Boolean norms;
    private Boolean docValues;
    private String analyzer;
    private String searchAnalyzer;
    private String copyTo;
    private DocProperty.Option options;

    public DocPropertyOptions() {
    }

    protected DocPropertyOptions(DocPropertyOptions source) {
        this.code = source.code;
        this.sortable = source.sortable;
        this.store = source.store;
        this.boost = source.boost;
        this.nullValue = source.nullValue;
        this.includeInAll = source.includeInAll;
        this.analyzer = source.analyzer;
        this.searchAnalyzer = source.searchAnalyzer;
        this.options = source.options;
        this.docValues = source.docValues;
        this.norms = source.norms;
        this.copyTo = source.copyTo;
        this.enabled = source.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.code != null) {
            sb.append("code:").append(this.code).append(" ");
        }
        if (this.sortable != null) {
            sb.append("sortable:").append(this.sortable).append(" ");
        }
        if (this.store != null) {
            sb.append("store:").append(this.store).append(" ");
        }
        if (this.boost != null) {
            sb.append("boost:").append(this.boost).append(" ");
        }
        if (this.nullValue != null) {
            sb.append("nullValue:").append(this.nullValue).append(" ");
        }
        return sb.toString();
    }

    public boolean isCode() {
        return Boolean.TRUE.equals(this.code);
    }

    public Boolean getCode() {
        return this.code;
    }

    public void setCode(Boolean code) {
        this.code = code;
    }

    public boolean isSortable() {
        return Boolean.TRUE.equals(this.sortable);
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public Float getBoost() {
        return this.boost;
    }

    public void setBoost(Float boost) {
        this.boost = boost;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public Boolean getStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public Boolean getIncludeInAll() {
        return this.includeInAll;
    }

    public void setIncludeInAll(Boolean includeInAll) {
        this.includeInAll = includeInAll;
    }

    public Boolean getDocValues() {
        return this.docValues;
    }

    public void setDocValues(Boolean docValues) {
        this.docValues = docValues;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
    }

    public String getCopyTo() {
        return this.copyTo;
    }

    public void setCopyTo(String copyTo) {
        this.copyTo = copyTo;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getNorms() {
        return this.norms;
    }

    public void setNorms(Boolean norms) {
        this.norms = norms;
    }

    public boolean isOptionsSet() {
        return this.options != null && this.options != DocProperty.Option.DEFAULT;
    }

    public DocProperty.Option getOptions() {
        return this.options;
    }

    public void setOptions(DocProperty.Option options) {
        this.options = options;
    }

    public DocPropertyOptions copy() {
        return new DocPropertyOptions(this);
    }

    public void apply(DocMapping docMapping) {
        this.apply(docMapping.options());
    }

    public void apply(DocProperty docMapping) {
        this.options = docMapping.options();
        if (docMapping.code()) {
            this.code = true;
        }
        if (docMapping.sortable()) {
            this.sortable = true;
        }
        if (docMapping.store()) {
            this.store = true;
        }
        if (Float.compare(docMapping.boost(), 1.0f) != 0) {
            this.boost = Float.valueOf(docMapping.boost());
        }
        if (!"".equals(docMapping.nullValue())) {
            this.nullValue = docMapping.nullValue();
        }
        if (!docMapping.includeInAll()) {
            this.includeInAll = false;
        }
        if (!docMapping.docValues()) {
            this.docValues = false;
        }
        if (!docMapping.enabled()) {
            this.enabled = false;
        }
        if (!docMapping.norms()) {
            this.norms = false;
        }
        if (!"".equals(docMapping.analyzer())) {
            this.analyzer = docMapping.analyzer();
        }
        if (!"".equals(docMapping.searchAnalyzer())) {
            this.searchAnalyzer = docMapping.searchAnalyzer();
        }
        if (!"".equals(docMapping.copyTo())) {
            this.copyTo = docMapping.copyTo();
        }
    }
}

