/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

class ScalarTypeJodaLocalTime
extends ScalarTypeBase<LocalTime> {
    ScalarTypeJodaLocalTime() {
        super(LocalTime.class, false, 92);
    }

    public void bind(DataBinder binder, LocalTime value) throws SQLException {
        if (value == null) {
            binder.setNull(92);
        } else {
            binder.setTime(new Time(value.toDateTimeToday().getMillis()));
        }
    }

    public LocalTime read(DataReader reader) throws SQLException {
        Time sqlTime = reader.getTime();
        if (sqlTime == null) {
            return null;
        }
        return new LocalTime((Object)sqlTime, DateTimeZone.getDefault());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof LocalTime) {
            LocalTime lt = (LocalTime)value;
            return new Time(lt.toDateTimeToday().getMillis());
        }
        return BasicTypeConverter.toTime(value);
    }

    public LocalTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new LocalTime(value, DateTimeZone.getDefault());
        }
        return (LocalTime)value;
    }

    public String formatValue(LocalTime v) {
        return v.toString();
    }

    public LocalTime parse(String value) {
        return new LocalTime((Object)value);
    }

    public LocalTime convertFromMillis(long systemTimeMillis) {
        return new LocalTime(systemTimeMillis, DateTimeZone.getDefault());
    }

    public boolean isDateTimeCapable() {
        return true;
    }

    public LocalTime readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String val = dataInput.readUTF();
        return this.parse(val);
    }

    public void writeData(DataOutput dataOutput, LocalTime value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.format(value));
        }
    }

    public void jsonWrite(JsonGenerator writer, LocalTime value) throws IOException {
        writer.writeString(value.toString());
    }

    public LocalTime jsonRead(JsonParser parser) throws IOException {
        if (JsonToken.VALUE_NUMBER_INT == parser.getCurrentToken()) {
            return this.convertFromMillis(parser.getLongValue());
        }
        return this.parse(parser.getValueAsString());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.KEYWORD;
    }
}

