/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.DataEncryptSupport;
import io.ebeaninternal.server.type.LocalEncryptedType;
import io.ebeaninternal.server.type.ScalarTypeBytesBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public final class ScalarTypeEncryptedWrapper<T>
implements ScalarType<T>,
LocalEncryptedType {
    private final ScalarType<T> wrapped;
    private final DataEncryptSupport dataEncryptSupport;
    private final ScalarTypeBytesBase byteArrayType;

    public ScalarTypeEncryptedWrapper(ScalarType<T> wrapped, ScalarTypeBytesBase byteArrayType, DataEncryptSupport dataEncryptSupport) {
        this.wrapped = wrapped;
        this.byteArrayType = byteArrayType;
        this.dataEncryptSupport = dataEncryptSupport;
    }

    @Override
    public Object localEncrypt(Object value) {
        String formatValue = this.wrapped.format(value);
        return this.dataEncryptSupport.encryptObject(formatValue);
    }

    public long asVersion(T value) {
        throw new RuntimeException("not supported");
    }

    public boolean isBinaryType() {
        return this.wrapped.isBinaryType();
    }

    public boolean isMutable() {
        return this.wrapped.isMutable();
    }

    public boolean isDirty(Object value) {
        return this.wrapped.isDirty(value);
    }

    public T readData(DataInput dataInput) throws IOException {
        return (T)this.wrapped.readData(dataInput);
    }

    public void writeData(DataOutput dataOutput, T v) throws IOException {
        this.wrapped.writeData(dataOutput, v);
    }

    public T read(DataReader reader) throws SQLException {
        byte[] data = reader.getBytes();
        String formattedValue = this.dataEncryptSupport.decryptObject(data);
        if (formattedValue == null) {
            return null;
        }
        return (T)this.wrapped.parse(formattedValue);
    }

    private byte[] encrypt(T value) {
        if (value == null) {
            return null;
        }
        String formatValue = this.wrapped.formatValue(value);
        return this.dataEncryptSupport.encryptObject(formatValue);
    }

    public void bind(DataBinder binder, T value) throws SQLException {
        byte[] encryptedValue = this.encrypt(value);
        this.byteArrayType.bind(binder, encryptedValue);
    }

    public int getJdbcType() {
        return this.byteArrayType.getJdbcType();
    }

    public int getLength() {
        return this.byteArrayType.getLength();
    }

    public Class<T> getType() {
        return this.wrapped.getType();
    }

    public boolean isDateTimeCapable() {
        return this.wrapped.isDateTimeCapable();
    }

    public boolean isJdbcNative() {
        return false;
    }

    public void loadIgnore(DataReader dataReader) {
        this.wrapped.loadIgnore(dataReader);
    }

    public String format(Object v) {
        return this.formatValue(v);
    }

    public String formatValue(T v) {
        return this.wrapped.formatValue(v);
    }

    public T parse(String value) {
        return (T)this.wrapped.parse(value);
    }

    public T convertFromMillis(long systemTimeMillis) {
        return (T)this.wrapped.convertFromMillis(systemTimeMillis);
    }

    public T toBeanType(Object value) {
        return (T)this.wrapped.toBeanType(value);
    }

    public Object toJdbcType(Object value) {
        return this.wrapped.toJdbcType(value);
    }

    public T jsonRead(JsonParser parser) throws IOException {
        return (T)this.wrapped.jsonRead(parser);
    }

    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        this.wrapped.jsonWrite(writer, value);
    }

    public DocPropertyType getDocType() {
        return this.wrapped.getDocType();
    }
}

