/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import java.math.BigDecimal;
import java.util.UUID;

interface ArrayElementConverter<T> {
    public static final ArrayElementConverter<UUID> UUID = new UuidConverter();
    public static final ArrayElementConverter<String> STRING = new StringConverter();
    public static final ArrayElementConverter<Long> LONG = new LongConverter();
    public static final ArrayElementConverter<Integer> INTEGER = new IntegerConverter();
    public static final ArrayElementConverter<Double> DOUBLE = new DoubleConverter();
    public static final ArrayElementConverter<BigDecimal> BIG_DECIMAL = new BigDecimalConverter();

    public T fromSerialized(Object var1);

    public T fromDbArray(Object var1);

    default public Object[] toDbArray(Object[] objects) {
        return objects;
    }

    public static class UuidConverter
    implements ArrayElementConverter<UUID> {
        @Override
        public UUID fromSerialized(Object rawValue) {
            return java.util.UUID.fromString((String)rawValue);
        }

        @Override
        public UUID fromDbArray(Object rawValue) {
            if (rawValue instanceof UUID) {
                return (UUID)rawValue;
            }
            return java.util.UUID.fromString(rawValue.toString());
        }
    }

    public static class StringConverter
    implements ArrayElementConverter<String> {
        @Override
        public String fromDbArray(Object rawValue) {
            return (String)rawValue;
        }

        @Override
        public String fromSerialized(Object rawValue) {
            return (String)rawValue;
        }
    }

    public static class LongConverter
    implements ArrayElementConverter<Long> {
        @Override
        public Long fromSerialized(Object rawValue) {
            return this.fromDbArray(rawValue);
        }

        @Override
        public Long fromDbArray(Object rawValue) {
            if (rawValue instanceof Long) {
                return (Long)rawValue;
            }
            return ((Number)rawValue).longValue();
        }
    }

    public static class IntegerConverter
    implements ArrayElementConverter<Integer> {
        @Override
        public Integer fromSerialized(Object rawValue) {
            return ((Number)rawValue).intValue();
        }

        @Override
        public Integer fromDbArray(Object rawValue) {
            if (rawValue instanceof Integer) {
                return (Integer)rawValue;
            }
            return ((Number)rawValue).intValue();
        }
    }

    public static class DoubleConverter
    implements ArrayElementConverter<Double> {
        @Override
        public Double fromSerialized(Object rawValue) {
            return this.fromDbArray(rawValue);
        }

        @Override
        public Double fromDbArray(Object rawValue) {
            if (rawValue instanceof Double) {
                return (Double)rawValue;
            }
            return ((Number)rawValue).doubleValue();
        }
    }

    public static class BigDecimalConverter
    implements ArrayElementConverter<BigDecimal> {
        @Override
        public BigDecimal fromSerialized(Object rawValue) {
            return this.fromDbArray(rawValue);
        }

        @Override
        public BigDecimal fromDbArray(Object rawValue) {
            if (rawValue instanceof BigDecimal) {
                return (BigDecimal)rawValue;
            }
            return BasicTypeConverter.toBigDecimal(rawValue);
        }
    }

    public static class EnumConverter
    implements ArrayElementConverter {
        private final ScalarType<?> scalarType;

        EnumConverter(ScalarType<?> scalarType) {
            this.scalarType = scalarType;
        }

        public Object fromSerialized(Object rawValue) {
            return this.scalarType.parse((String)rawValue);
        }

        public Object fromDbArray(Object rawValue) {
            return this.scalarType.toBeanType(rawValue);
        }

        @Override
        public Object[] toDbArray(Object[] objects) {
            Object[] dbArray = new Object[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                dbArray[i] = this.scalarType.toJdbcType(objects[i]);
            }
            return dbArray;
        }
    }
}

