/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.event.changelog.TxnState;
import io.ebeaninternal.api.SpiTransaction;
import java.util.UUID;

public final class TChangeLogHolder {
    private final SpiTransaction owner;
    private final String transactionId;
    private final int batchSize;
    private ChangeSet changes;
    private long batchId;
    private int count;

    public TChangeLogHolder(SpiTransaction owner, int batchSize) {
        this.owner = owner;
        this.transactionId = UUID.randomUUID().toString();
        this.batchSize = batchSize;
        this.changes = new ChangeSet(this.transactionId, 0L);
    }

    public void addBeanChange(BeanChange change) {
        this.changes.addBeanChange(change);
        if (++this.count >= this.batchSize) {
            this.sendChanges();
        }
    }

    private void sendChanges() {
        this.owner.sendChangeLog(this.changes);
        this.changes = new ChangeSet(this.transactionId, ++this.batchId);
        this.count = 0;
    }

    public void preCommit() {
        this.sendChanges();
    }

    public void postCommit() {
        this.changes.setTxnState(TxnState.COMMITTED);
        this.owner.sendChangeLog(this.changes);
    }

    public void postRollback() {
        this.changes.setTxnState(TxnState.ROLLBACK);
        this.owner.sendChangeLog(this.changes);
    }
}

