/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.QueryIterator;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.query.CQuery;
import java.sql.SQLException;

final class CQueryIteratorSimple<T>
implements QueryIterator<T> {
    private final CQuery<T> cquery;
    private final OrmQueryRequest<T> request;
    private boolean closed;

    CQueryIteratorSimple(CQuery<T> cquery, OrmQueryRequest<T> request) {
        this.cquery = cquery;
        this.request = request;
    }

    public boolean hasNext() {
        boolean ret = false;
        try {
            boolean bl = ret = this.cquery.hasNext();
            return bl;
        }
        catch (SQLException e) {
            throw this.cquery.createPersistenceException(e);
        }
        finally {
            if (!ret) {
                this.close();
            }
        }
    }

    public T next() {
        return (T)this.cquery.next();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.cquery.updateExecutionStatisticsIterator();
            this.cquery.close();
            this.request.endTransIfRequired();
        }
    }
}

