/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPostConstructListener;
import java.util.ArrayList;
import java.util.List;

public final class ChainedBeanPostConstructListener
implements BeanPostConstructListener {
    private final List<BeanPostConstructListener> list;
    private final BeanPostConstructListener[] chain;

    public ChainedBeanPostConstructListener(List<BeanPostConstructListener> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPostConstructListener[0]);
    }

    public ChainedBeanPostConstructListener register(BeanPostConstructListener c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPostConstructListener> newList = new ArrayList<BeanPostConstructListener>(this.list);
        newList.add(c);
        return new ChainedBeanPostConstructListener(newList);
    }

    public BeanPostConstructListener deregister(BeanPostConstructListener c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPostConstructListener> newList = new ArrayList<BeanPostConstructListener>(this.list);
        newList.remove(c);
        return new ChainedBeanPostConstructListener(newList);
    }

    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    public void postConstruct(Object bean) {
        for (BeanPostConstructListener listener : this.chain) {
            listener.postConstruct(bean);
        }
    }

    public void autowire(Object bean) {
        for (BeanPostConstructListener listener : this.chain) {
            listener.autowire(bean);
        }
    }

    public void postCreate(Object bean) {
        for (BeanPostConstructListener listener : this.chain) {
            listener.postCreate(bean);
        }
    }
}

