/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanDeleteIdRequest;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ChainedBeanPersistController
implements BeanPersistController {
    private static final Sorter SORTER = new Sorter();
    private final List<BeanPersistController> list;
    private final BeanPersistController[] chain;

    public ChainedBeanPersistController(BeanPersistController c1, BeanPersistController c2) {
        this(ChainedBeanPersistController.addList(c1, c2));
    }

    private static List<BeanPersistController> addList(BeanPersistController c1, BeanPersistController c2) {
        ArrayList<BeanPersistController> addList = new ArrayList<BeanPersistController>(2);
        addList.add(c1);
        addList.add(c2);
        return addList;
    }

    public ChainedBeanPersistController(List<BeanPersistController> list) {
        this.list = list;
        BeanPersistController[] c = list.toArray(new BeanPersistController[0]);
        Arrays.sort(c, SORTER);
        this.chain = c;
    }

    int size() {
        return this.chain.length;
    }

    public ChainedBeanPersistController register(BeanPersistController c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistController> newList = new ArrayList<BeanPersistController>(this.list);
        newList.add(c);
        return new ChainedBeanPersistController(newList);
    }

    public ChainedBeanPersistController deregister(BeanPersistController c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistController> newList = new ArrayList<BeanPersistController>(this.list);
        newList.remove(c);
        return new ChainedBeanPersistController(newList);
    }

    public int getExecutionOrder() {
        return 0;
    }

    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    public void postDelete(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            controller.postDelete(request);
        }
    }

    public void postInsert(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            controller.postInsert(request);
        }
    }

    public void postUpdate(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            controller.postUpdate(request);
        }
    }

    public void postSoftDelete(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            controller.postSoftDelete(request);
        }
    }

    public boolean preDelete(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            if (controller.preDelete(request)) continue;
            return false;
        }
        return true;
    }

    public boolean preSoftDelete(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            if (controller.preSoftDelete(request)) continue;
            return false;
        }
        return true;
    }

    public void preDelete(BeanDeleteIdRequest request) {
        for (BeanPersistController controller : this.chain) {
            controller.preDelete(request);
        }
    }

    public boolean preInsert(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            if (controller.preInsert(request)) continue;
            return false;
        }
        return true;
    }

    public boolean preUpdate(BeanPersistRequest<?> request) {
        for (BeanPersistController controller : this.chain) {
            if (controller.preUpdate(request)) continue;
            return false;
        }
        return true;
    }

    private static final class Sorter
    implements Comparator<BeanPersistController> {
        private Sorter() {
        }

        @Override
        public int compare(BeanPersistController o1, BeanPersistController o2) {
            return Integer.compare(o1.getExecutionOrder(), o2.getExecutionOrder());
        }
    }
}

