/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanCollectionHelp;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanListHelp;
import io.ebeaninternal.server.deploy.BeanListHelpElement;
import io.ebeaninternal.server.deploy.BeanMapHelp;
import io.ebeaninternal.server.deploy.BeanMapHelpElement;
import io.ebeaninternal.server.deploy.BeanMapQueryHelp;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanSetHelp;
import io.ebeaninternal.server.deploy.BeanSetHelpElement;
import io.ebeaninternal.server.deploy.ManyType;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.query.CQueryCollectionAdd;

public final class BeanCollectionHelpFactory {
    private static final BeanListHelp LIST_HELP = new BeanListHelp();
    private static final BeanSetHelp SET_HELP = new BeanSetHelp();

    public static <T> BeanCollectionHelp<T> create(BeanPropertyAssocMany<T> many) {
        boolean elementCollection = many.isElementCollection();
        ManyType manyType = many.manyType();
        switch (manyType) {
            case LIST: {
                return elementCollection ? new BeanListHelpElement<T>(many) : new BeanListHelp<T>(many);
            }
            case SET: {
                return elementCollection ? new BeanSetHelpElement<T>(many) : new BeanSetHelp<T>(many);
            }
            case MAP: {
                return elementCollection ? new BeanMapHelpElement<T>(many) : new BeanMapHelp<T>(many);
            }
        }
        throw new RuntimeException("Invalid type " + manyType);
    }

    public static <T> CQueryCollectionAdd<T> create(SpiQuery.Type manyType, OrmQueryRequest<T> request) {
        if (manyType == SpiQuery.Type.LIST) {
            return LIST_HELP;
        }
        if (manyType == SpiQuery.Type.SET) {
            return SET_HELP;
        }
        if (manyType == SpiQuery.Type.MAP) {
            BeanDescriptor<T> target = request.descriptor();
            ElPropertyValue elProperty = target.elGetValue(request.query().getMapKey());
            return new BeanMapQueryHelp(elProperty);
        }
        return null;
    }
}

