/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import io.ebean.AutoTune;
import io.ebean.BackgroundExecutor;
import io.ebean.BeanState;
import io.ebean.CallableSql;
import io.ebean.Database;
import io.ebean.DocumentStore;
import io.ebean.DtoQuery;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.ExtendedServer;
import io.ebean.Filter;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.MergeOptions;
import io.ebean.MergeOptionsBuilder;
import io.ebean.PagedList;
import io.ebean.PersistenceContextScope;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.RowConsumer;
import io.ebean.RowMapper;
import io.ebean.ScriptRunner;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.TransactionCallback;
import io.ebean.TxScope;
import io.ebean.Update;
import io.ebean.UpdateQuery;
import io.ebean.ValuePair;
import io.ebean.Version;
import io.ebean.annotation.Platform;
import io.ebean.annotation.TxIsolation;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.CallOrigin;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.bean.SingleBeanLoader;
import io.ebean.cache.ServerCacheManager;
import io.ebean.common.CopyOnFirstWriteList;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.QueryPlanCapture;
import io.ebean.config.QueryPlanListener;
import io.ebean.config.SlowQueryEvent;
import io.ebean.config.SlowQueryListener;
import io.ebean.config.TenantMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.event.BeanPersistController;
import io.ebean.event.ShutdownManager;
import io.ebean.event.readaudit.ReadAuditLogger;
import io.ebean.event.readaudit.ReadAuditPrepare;
import io.ebean.meta.MetaInfoManager;
import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.MetricVisitor;
import io.ebean.meta.QueryPlanInit;
import io.ebean.meta.QueryPlanRequest;
import io.ebean.migration.auto.AutoMigrationRunner;
import io.ebean.plugin.BeanType;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.Property;
import io.ebean.plugin.SpiServer;
import io.ebean.text.csv.CsvReader;
import io.ebean.text.json.JsonContext;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.ExtraMetrics;
import io.ebeaninternal.api.LoadBeanRequest;
import io.ebeaninternal.api.LoadManyRequest;
import io.ebeaninternal.api.QueryPlanManager;
import io.ebeaninternal.api.ScopedTransaction;
import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.api.SpiDdlGenerator;
import io.ebeaninternal.api.SpiDtoQuery;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiJsonContext;
import io.ebeaninternal.api.SpiLogManager;
import io.ebeaninternal.api.SpiPersistenceContext;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.api.SpiSqlQuery;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTransactionManager;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.autotune.AutoTuneService;
import io.ebeaninternal.server.cache.RemoteCacheEvent;
import io.ebeaninternal.server.core.CallOriginFactory;
import io.ebeaninternal.server.core.ClockService;
import io.ebeaninternal.server.core.DScriptRunner;
import io.ebeaninternal.server.core.DefaultBeanLoader;
import io.ebeaninternal.server.core.DefaultBeanState;
import io.ebeaninternal.server.core.DefaultCallOriginFactory;
import io.ebeaninternal.server.core.DefaultCallableSql;
import io.ebeaninternal.server.core.DefaultMetaInfoManager;
import io.ebeaninternal.server.core.DefaultQueryPlanListener;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.core.DiffHelp;
import io.ebeaninternal.server.core.DtoQueryRequest;
import io.ebeaninternal.server.core.DumpMetrics;
import io.ebeaninternal.server.core.InternalConfiguration;
import io.ebeaninternal.server.core.NoopCallOriginFactory;
import io.ebeaninternal.server.core.ObtainedTransaction;
import io.ebeaninternal.server.core.ObtainedTransactionImplicit;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.Persister;
import io.ebeaninternal.server.core.RelationalQueryEngine;
import io.ebeaninternal.server.core.RelationalQueryRequest;
import io.ebeaninternal.server.core.ServiceUtil;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.dto.DtoBeanDescriptor;
import io.ebeaninternal.server.dto.DtoBeanManager;
import io.ebeaninternal.server.el.ElFilter;
import io.ebeaninternal.server.grammer.EqlParser;
import io.ebeaninternal.server.query.CQuery;
import io.ebeaninternal.server.query.CQueryEngine;
import io.ebeaninternal.server.query.CallableQueryCount;
import io.ebeaninternal.server.query.CallableQueryIds;
import io.ebeaninternal.server.query.CallableQueryList;
import io.ebeaninternal.server.query.DtoQueryEngine;
import io.ebeaninternal.server.query.LimitOffsetPagedList;
import io.ebeaninternal.server.query.QueryFutureIds;
import io.ebeaninternal.server.query.QueryFutureList;
import io.ebeaninternal.server.query.QueryFutureRowCount;
import io.ebeaninternal.server.querydefn.DefaultDtoQuery;
import io.ebeaninternal.server.querydefn.DefaultOrmQuery;
import io.ebeaninternal.server.querydefn.DefaultOrmUpdate;
import io.ebeaninternal.server.querydefn.DefaultRelationalQuery;
import io.ebeaninternal.server.querydefn.DefaultUpdateQuery;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.text.csv.TCsvReader;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import io.ebeaninternal.server.transaction.RemoteTransactionEvent;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.util.ParamTypeHelper;
import io.ebeanservice.docstore.api.DocStoreIntegration;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;

@NonNullApi
public final class DefaultServer
implements SpiServer,
SpiEbeanServer {
    private static final Logger log = CoreLog.internal;
    private final ReentrantLock lock = new ReentrantLock();
    private final DatabaseConfig config;
    private final String serverName;
    private final DatabasePlatform databasePlatform;
    private final TransactionManager transactionManager;
    private final QueryPlanManager queryPlanManager;
    private final ExtraMetrics extraMetrics;
    private final DataTimeZone dataTimeZone;
    private final ClockService clockService;
    private final CallOriginFactory callStackFactory;
    private final Persister persister;
    private final OrmQueryEngine queryEngine;
    private final RelationalQueryEngine relationalQueryEngine;
    private final DtoQueryEngine dtoQueryEngine;
    private final ServerCacheManager serverCacheManager;
    private final DtoBeanManager dtoBeanManager;
    private final BeanDescriptorManager descriptorManager;
    private final AutoTuneService autoTuneService;
    private final ReadAuditPrepare readAuditPrepare;
    private final ReadAuditLogger readAuditLogger;
    private final CQueryEngine cqueryEngine;
    private final List<Plugin> serverPlugins;
    private final SpiDdlGenerator ddlGenerator;
    private final ScriptRunner scriptRunner;
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final DefaultBeanLoader beanLoader;
    private final EncryptKeyManager encryptKeyManager;
    private final SpiJsonContext jsonContext;
    private final DocumentStore documentStore;
    private final MetaInfoManager metaInfoManager;
    private final CurrentTenantProvider currentTenantProvider;
    private final SpiLogManager logManager;
    private final PersistenceContextScope defaultPersistenceContextScope;
    private final int lazyLoadBatchSize;
    private final boolean updateAllPropertiesInBatch;
    private final long slowQueryMicros;
    private final SlowQueryListener slowQueryListener;
    private final boolean disableL2Cache;
    private boolean shutdown;

    public DefaultServer(InternalConfiguration config, ServerCacheManager cache) {
        this.logManager = config.getLogManager();
        this.dtoBeanManager = config.getDtoBeanManager();
        this.config = config.getConfig();
        this.disableL2Cache = this.config.isDisableL2Cache();
        this.serverCacheManager = cache;
        this.databasePlatform = config.getDatabasePlatform();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.extraMetrics = config.getExtraMetrics();
        this.serverName = this.config.getName();
        this.lazyLoadBatchSize = this.config.getLazyLoadBatchSize();
        this.cqueryEngine = config.getCQueryEngine();
        this.expressionFactory = config.getExpressionFactory();
        this.encryptKeyManager = this.config.getEncryptKeyManager();
        this.defaultPersistenceContextScope = this.config.getPersistenceContextScope();
        this.currentTenantProvider = this.config.getCurrentTenantProvider();
        this.slowQueryMicros = config.getSlowQueryMicros();
        this.slowQueryListener = config.getSlowQueryListener();
        this.descriptorManager = config.getBeanDescriptorManager();
        this.descriptorManager.setEbeanServer(this);
        this.updateAllPropertiesInBatch = this.config.isUpdateAllPropertiesInBatch();
        this.callStackFactory = this.initCallStackFactory(this.config);
        this.persister = config.createPersister(this);
        this.queryEngine = config.createOrmQueryEngine();
        this.relationalQueryEngine = config.createRelationalQueryEngine();
        this.dtoQueryEngine = config.createDtoQueryEngine();
        this.autoTuneService = config.createAutoTuneService(this);
        this.readAuditPrepare = config.getReadAuditPrepare();
        this.readAuditLogger = config.getReadAuditLogger();
        this.beanLoader = new DefaultBeanLoader(this);
        this.jsonContext = config.createJsonContext(this);
        this.dataTimeZone = config.getDataTimeZone();
        this.clockService = config.getClockService();
        DocStoreIntegration docStoreComponents = config.createDocStoreIntegration(this);
        this.transactionManager = config.createTransactionManager(this, docStoreComponents.updateProcessor());
        this.documentStore = docStoreComponents.documentStore();
        this.queryPlanManager = config.initQueryPlanManager(this.transactionManager);
        this.metaInfoManager = new DefaultMetaInfoManager(this);
        this.serverPlugins = config.getPlugins();
        this.ddlGenerator = config.initDdlGenerator(this);
        this.scriptRunner = new DScriptRunner(this);
        this.configureServerPlugins();
        ShutdownManager.registerDatabase((Database)this);
    }

    private CallOriginFactory initCallStackFactory(DatabaseConfig config) {
        if (!config.getAutoTuneConfig().isActive()) {
            return new NoopCallOriginFactory();
        }
        return new DefaultCallOriginFactory(config.getMaxCallStack());
    }

    private void configureServerPlugins() {
        this.autoTuneService.startup();
        for (Plugin plugin : this.serverPlugins) {
            plugin.configure((SpiServer)this);
        }
    }

    public void executePlugins(boolean online) {
        if (!this.config.isDocStoreOnly()) {
            this.ddlGenerator.execute(online);
        }
        for (Plugin plugin : this.serverPlugins) {
            plugin.online(online);
        }
    }

    @Override
    public boolean isDisableL2Cache() {
        return this.disableL2Cache;
    }

    @Override
    public SpiLogManager log() {
        return this.logManager;
    }

    @Override
    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    @Override
    public int lazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    @Nullable
    public Object currentTenantId() {
        return this.currentTenantProvider == null ? null : this.currentTenantProvider.currentId();
    }

    public DatabaseConfig config() {
        return this.config;
    }

    public DatabasePlatform databasePlatform() {
        return this.databasePlatform;
    }

    public ScriptRunner script() {
        return this.scriptRunner;
    }

    @Override
    public DataTimeZone dataTimeZone() {
        return this.dataTimeZone;
    }

    public MetaInfoManager metaInfo() {
        return this.metaInfoManager;
    }

    public Platform platform() {
        return this.databasePlatform.getPlatform();
    }

    public SpiServer pluginApi() {
        return this;
    }

    public BackgroundExecutor backgroundExecutor() {
        return this.backgroundExecutor;
    }

    public ExpressionFactory expressionFactory() {
        return this.expressionFactory;
    }

    public AutoTune autoTune() {
        return this.autoTuneService;
    }

    public DataSource dataSource() {
        return this.transactionManager.dataSource();
    }

    public DataSource readOnlyDataSource() {
        return this.transactionManager.readOnlyDataSource();
    }

    @Override
    public ReadAuditPrepare readAuditPrepare() {
        return this.readAuditPrepare;
    }

    @Override
    public ReadAuditLogger readAuditLogger() {
        return this.readAuditLogger;
    }

    public void initialise() {
        if (this.encryptKeyManager != null) {
            this.encryptKeyManager.initialise();
        }
        this.serverCacheManager.enabledRegions(this.config.getEnabledL2Regions());
    }

    public void start() {
        if (this.config.isRunMigration() && TenantMode.DB != this.config.getTenantMode()) {
            AutoMigrationRunner migrationRunner = ServiceUtil.service(AutoMigrationRunner.class);
            if (migrationRunner == null) {
                throw new IllegalStateException("No AutoMigrationRunner found. Probably ebean-migration is not in the classpath?");
            }
            String dbSchema = this.config.getDbSchema();
            if (dbSchema != null) {
                migrationRunner.setDefaultDbSchema(dbSchema);
            }
            migrationRunner.setName(this.config.getName());
            Platform platform = this.config.getDatabasePlatform().getPlatform();
            migrationRunner.setBasePlatform(platform.base().name().toLowerCase());
            migrationRunner.setPlatform(platform.name().toLowerCase());
            migrationRunner.loadProperties(this.config.getProperties());
            migrationRunner.run(this.config.getDataSource());
        }
        this.startQueryPlanCapture();
    }

    private void startQueryPlanCapture() {
        long secs;
        if (this.config.isQueryPlanCapture() && (secs = this.config.getQueryPlanCapturePeriodSecs()) > 10L) {
            log.info("capture query plan enabled, every {}secs", (Object)secs);
            this.backgroundExecutor.scheduleWithFixedDelay(this::collectQueryPlans, secs, secs, TimeUnit.SECONDS);
        }
    }

    private void collectQueryPlans() {
        QueryPlanRequest request = new QueryPlanRequest();
        request.maxCount(this.config.getQueryPlanCaptureMaxCount());
        request.maxTimeMillis(this.config.getQueryPlanCaptureMaxTimeMillis());
        List plans = this.metaInfoManager.queryPlanCollectNow(request);
        QueryPlanListener listener = this.config.getQueryPlanListener();
        if (listener == null) {
            listener = DefaultQueryPlanListener.INSTANT;
        }
        listener.process(new QueryPlanCapture((Database)this, plans));
    }

    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdownInternal(true, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        this.lock.lock();
        try {
            ShutdownManager.unregisterDatabase((Database)this);
            this.shutdownInternal(shutdownDataSource, deregisterDriver);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void shutdownInternal(boolean shutdownDataSource, boolean deregisterDriver) {
        log.trace("shutting down instance {}", (Object)this.serverName);
        if (this.shutdown) {
            return;
        }
        this.shutdownPlugins();
        this.autoTuneService.shutdown();
        this.backgroundExecutor.shutdown();
        this.transactionManager.shutdown(shutdownDataSource, deregisterDriver);
        this.dumpMetrics();
        this.shutdown = true;
        if (shutdownDataSource) {
            this.config.setDataSource(null);
        }
    }

    private void dumpMetrics() {
        if (this.config.isDumpMetricsOnShutdown()) {
            new DumpMetrics(this, this.config.getDumpMetricsOptions()).dump();
        }
    }

    private void shutdownPlugins() {
        for (Plugin plugin : this.serverPlugins) {
            try {
                plugin.shutdown();
            }
            catch (Exception e) {
                log.error("Error when shutting down plugin", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Database{" + this.serverName + "}";
    }

    public String name() {
        return this.serverName;
    }

    public ExtendedServer extended() {
        return this;
    }

    public long clockNow() {
        return this.clockService.nowMillis();
    }

    public void setClock(Clock clock) {
        this.clockService.setClock(clock);
    }

    public BeanState beanState(Object bean) {
        if (bean instanceof EntityBean) {
            return new DefaultBeanState((EntityBean)bean);
        }
        throw new IllegalArgumentException("Bean is not an entity bean");
    }

    @Override
    public <T> CQuery<T> compileQuery(SpiQuery.Type type, Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> qr = this.createQueryRequest(type, query, transaction);
        OrmQueryRequest orm = (OrmQueryRequest)qr;
        return this.cqueryEngine.buildQuery(orm);
    }

    public ServerCacheManager cacheManager() {
        return this.serverCacheManager;
    }

    public void refreshMany(Object parentBean, String propertyName) {
        this.beanLoader.refreshMany(this.checkEntityBean(parentBean), propertyName);
    }

    @Override
    public void loadMany(LoadManyRequest loadRequest) {
        this.beanLoader.loadMany(loadRequest);
    }

    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        this.beanLoader.loadMany(bc, onlyIds);
    }

    public void refresh(Object bean) {
        this.beanLoader.refresh(this.checkEntityBean(bean));
    }

    @Override
    public void loadBean(LoadBeanRequest loadRequest) {
        this.beanLoader.loadBean(loadRequest);
    }

    public BeanLoader beanLoader() {
        return new SingleBeanLoader.Dflt((Database)this);
    }

    public void loadBean(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
        this.extraMetrics.incrementLoadOneNoLoader();
    }

    public void loadBeanRef(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
        this.extraMetrics.incrementLoadOneRef();
    }

    public void loadBeanL2(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
        this.extraMetrics.incrementLoadOneL2();
    }

    public Map<String, ValuePair> diff(@Nullable Object a, Object b) {
        if (a == null) {
            return Collections.emptyMap();
        }
        BeanDescriptor<?> desc = this.descriptor(a.getClass());
        return DiffHelp.diff(a, b, desc);
    }

    @Override
    public void externalModification(TransactionEventTable tableEvent) {
        this.transactionManager.externalModification(tableEvent);
    }

    public void externalModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        TransactionEventTable evt = new TransactionEventTable();
        evt.add(tableName, inserts, updates, deletes);
        this.externalModification(evt);
    }

    public void truncate(Class<?> ... types) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Class<?> type : types) {
            tableNames.add(this.descriptor(type).baseTable());
        }
        this.truncate(tableNames.toArray(new String[0]));
    }

    public void truncate(String ... tables) {
        try (Connection connection = this.dataSource().getConnection();){
            for (String table : tables) {
                this.executeSql(connection, this.databasePlatform.truncateStatement(table));
                if (this.databasePlatform.getPlatform().base() != Platform.DB2) continue;
                connection.commit();
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new PersistenceException("Error executing truncate", (Throwable)e);
        }
    }

    private void executeSql(Connection connection, @Nullable String sql) throws SQLException {
        if (sql != null) {
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                this.transactionManager.log().sql().debug(sql);
                stmt.execute();
            }
        }
    }

    @Override
    public void clearQueryStatistics() {
        for (BeanDescriptor<?> desc : this.descriptors()) {
            desc.clearQueryStatistics();
        }
    }

    public <T> T createEntityBean(Class<T> type) {
        return this.descriptor(type).createBean();
    }

    public <T> T reference(Class<T> type, Object id) {
        Object existing;
        Objects.requireNonNull(id);
        BeanDescriptor<T> desc = this.descriptor(type);
        id = desc.convertId(id);
        SpiPersistenceContext pc = null;
        SpiTransaction t = this.transactionManager.active();
        if (t != null && (existing = desc.contextGet(pc = t.getPersistenceContext(), id)) != null) {
            return (T)existing;
        }
        InheritInfo inheritInfo = desc.inheritInfo();
        if (inheritInfo == null || inheritInfo.isConcrete()) {
            return (T)desc.contextRef(pc, null, false, id);
        }
        return this.referenceFindOne(type, id, desc);
    }

    private <T> T referenceFindOne(Class<T> type, Object id, BeanDescriptor<?> desc) {
        BeanProperty idProp = desc.idProperty();
        if (idProp == null) {
            throw new PersistenceException("No ID properties for this type? " + desc);
        }
        return (T)this.find(type).select(idProp.name()).setId(id).findOne();
    }

    public void register(TransactionCallback transactionCallback) {
        SpiTransaction transaction = this.transactionManager.active();
        if (transaction == null) {
            throw new PersistenceException("Not currently active transaction when trying to register transactionCallback");
        }
        transaction.register(transactionCallback);
    }

    public Transaction createTransaction() {
        return this.transactionManager.createTransaction(true, -1);
    }

    public Transaction createTransaction(TxIsolation isolation) {
        return this.transactionManager.createTransaction(true, isolation.getLevel());
    }

    public <T> T executeCall(Callable<T> callable) {
        return this.executeCall(null, callable);
    }

    public <T> T executeCall(@Nullable TxScope scope, Callable<T> callable) {
        ScopedTransaction scopeTrans = this.transactionManager.beginScopedTransaction(scope);
        try {
            T t = callable.call();
            return t;
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)scopeTrans.caughtThrowable(e));
        }
        finally {
            scopeTrans.complete();
        }
    }

    public void execute(Runnable runnable) {
        this.execute(null, runnable);
    }

    public void execute(@Nullable TxScope scope, Runnable runnable) {
        ScopedTransaction t = this.transactionManager.beginScopedTransaction(scope);
        try {
            runnable.run();
        }
        catch (Error e) {
            throw t.caughtError(e);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)t.caughtThrowable(e));
        }
        finally {
            t.complete();
        }
    }

    @Override
    public void scopedTransactionEnter(TxScope txScope) {
        this.beginTransaction(txScope);
    }

    @Override
    public void scopedTransactionExit(Object returnOrThrowable, int opCode) {
        this.transactionManager.exitScopedTransaction(returnOrThrowable, opCode);
    }

    @Override
    @Nullable
    public SpiTransaction currentServerTransaction() {
        return this.transactionManager.active();
    }

    public Transaction beginTransaction() {
        return this.beginTransaction(TxScope.required());
    }

    public Transaction beginTransaction(TxScope txScope) {
        return this.transactionManager.beginScopedTransaction(txScope);
    }

    public Transaction beginTransaction(TxIsolation isolation) {
        SpiTransaction t = this.transactionManager.createTransaction(true, isolation.getLevel());
        try {
            this.transactionManager.set(t);
        }
        catch (PersistenceException existingTransactionError) {
            t.end();
            throw existingTransactionError;
        }
        return t;
    }

    public Transaction currentTransaction() {
        return this.transactionManager.active();
    }

    public void flush() {
        this.currentTransaction().flush();
    }

    public void commitTransaction() {
        this.currentTransaction().commit();
    }

    public void rollbackTransaction() {
        this.currentTransaction().rollback();
    }

    public void endTransaction() {
        SpiTransaction transaction = this.transactionManager.inScope();
        if (transaction != null) {
            transaction.end();
        }
    }

    public Object nextId(Class<?> beanType) {
        return this.descriptor(beanType).nextId(null);
    }

    public <T> void sort(List<T> list, String sortByClause) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(sortByClause);
        if (list.isEmpty()) {
            return;
        }
        Class<?> beanType = list.get(0).getClass();
        this.desc(beanType).sort(list, sortByClause);
    }

    public <T> Set<String> validateQuery(Query<T> query) {
        return ((SpiQuery)query).validate(this.desc(query.getBeanType()));
    }

    public <T> Filter<T> filter(Class<T> beanType) {
        return new ElFilter<T>(this.desc(beanType));
    }

    public <T> CsvReader<T> createCsvReader(Class<T> beanType) {
        return new TCsvReader<T>((Database)this, this.desc(beanType));
    }

    public <T> UpdateQuery<T> update(Class<T> beanType) {
        return new DefaultUpdateQuery(this.createQuery((Class)beanType));
    }

    public void merge(Object bean) {
        this.merge(bean, MergeOptionsBuilder.defaultOptions(), null);
    }

    public void merge(Object bean, MergeOptions options) {
        this.merge(bean, options, null);
    }

    public void merge(Object bean, MergeOptions options, @Nullable Transaction transaction) {
        BeanDescriptor<?> desc = this.desc(bean.getClass());
        this.executeInTrans(txn -> this.persister.merge(desc, this.checkEntityBean(bean), options, (SpiTransaction)txn), transaction);
    }

    public void lock(Object bean) {
        BeanDescriptor<?> desc = this.desc(bean.getClass());
        Object id = desc.id(bean);
        Objects.requireNonNull(id, "Bean missing an @Id value which is required to lock");
        new DefaultOrmQuery(desc, this, this.expressionFactory).setId(id).withLock(Query.LockType.DEFAULT, Query.LockWait.NOWAIT).findOne();
    }

    public <T> Query<T> find(Class<T> beanType) {
        return this.createQuery((Class)beanType);
    }

    public <T> Query<T> findNative(Class<T> beanType, String nativeSql) {
        DefaultOrmQuery<T> query = new DefaultOrmQuery<T>(this.desc(beanType), this, this.expressionFactory);
        query.setNativeSql(nativeSql);
        return query;
    }

    public <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) {
        BeanDescriptor<T> desc = this.desc(beanType);
        String named = desc.namedQuery(namedQuery);
        if (named != null) {
            return this.createQuery((Class)beanType, named);
        }
        SpiRawSql rawSql = desc.namedRawSql(namedQuery);
        if (rawSql != null) {
            Query query = this.createQuery((Class)beanType);
            query.setRawSql(rawSql);
            return query;
        }
        throw new PersistenceException("No named query called " + namedQuery + " for bean:" + beanType.getName());
    }

    public <T> DefaultOrmQuery<T> createQuery(Class<T> beanType, String eql) {
        Query query = this.createQuery((Class)beanType);
        EqlParser.parse(eql, query);
        return query;
    }

    public <T> DefaultOrmQuery<T> createQuery(Class<T> beanType) {
        return new DefaultOrmQuery<T>(this.desc(beanType), this, this.expressionFactory);
    }

    public <T> Update<T> createUpdate(Class<T> beanType, String ormUpdate) {
        return new DefaultOrmUpdate(beanType, this, this.desc(beanType).baseTable(), ormUpdate);
    }

    public <T> DtoQuery<T> findDto(Class<T> dtoType, String sql) {
        DtoBeanDescriptor<T> descriptor = this.dtoBeanManager.getDescriptor(dtoType);
        return new DefaultDtoQuery<T>((SpiEbeanServer)this, descriptor, sql.trim());
    }

    public <T> DtoQuery<T> createNamedDtoQuery(Class<T> dtoType, String namedQuery) {
        DtoBeanDescriptor<T> descriptor = this.dtoBeanManager.getDescriptor(dtoType);
        String sql = descriptor.getNamedRawSql(namedQuery);
        if (sql == null) {
            throw new PersistenceException("No named query called " + namedQuery + " for bean:" + dtoType.getName());
        }
        return new DefaultDtoQuery<T>((SpiEbeanServer)this, descriptor, sql);
    }

    public <T> DtoQuery<T> findDto(Class<T> dtoType, SpiQuery<?> ormQuery) {
        DtoBeanDescriptor<T> descriptor = this.dtoBeanManager.getDescriptor(dtoType);
        return new DefaultDtoQuery<T>((SpiEbeanServer)this, descriptor, ormQuery);
    }

    @Override
    public SpiResultSet findResultSet(SpiQuery<?> ormQuery, SpiTransaction transaction) {
        SpiOrmQueryRequest<?> request = this.createQueryRequest(ormQuery.getType(), ormQuery, transaction);
        request.initTransIfRequired();
        return request.findResultSet();
    }

    public SqlQuery sqlQuery(String sql) {
        return new DefaultRelationalQuery(this, sql.trim());
    }

    public SqlQuery createSqlQuery(String sql) {
        return this.sqlQuery(sql);
    }

    public SqlUpdate sqlUpdate(String sql) {
        return new DefaultSqlUpdate(this, sql.trim());
    }

    public SqlUpdate createSqlUpdate(String sql) {
        return this.sqlUpdate(sql);
    }

    public CallableSql createCallableSql(String sql) {
        return new DefaultCallableSql((Database)this, sql.trim());
    }

    public <T> T find(Class<T> beanType, Object uid) {
        return this.find(beanType, uid, null);
    }

    public <T> T find(Class<T> beanType, Object id, @Nullable Transaction transaction) {
        Objects.requireNonNull(id);
        Query query = this.createQuery((Class)beanType).setId(id);
        return this.findId(query, transaction);
    }

    <T> SpiOrmQueryRequest<T> createQueryRequest(SpiQuery.Type type, Query<T> query, @Nullable Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.buildQueryRequest(type, query, transaction);
        request.prepareQuery();
        return request;
    }

    <T> SpiOrmQueryRequest<T> buildQueryRequest(SpiQuery.Type type, Query<T> query, @Nullable Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(type);
        spiQuery.checkNamedParameters();
        return this.buildQueryRequest(spiQuery, transaction);
    }

    private <T> SpiOrmQueryRequest<T> buildQueryRequest(SpiQuery<T> query, @Nullable Transaction transaction) {
        if (transaction == null) {
            transaction = this.currentServerTransaction();
        }
        query.setDefaultRawSqlIfRequired();
        if (query.isAutoTunable() && !this.autoTuneService.tuneQuery(query)) {
            query.setDefaultSelectClause();
        }
        query.selectAllForLazyLoadProperty();
        ProfileLocation profileLocation = query.getProfileLocation();
        if (profileLocation != null) {
            profileLocation.obtain();
        }
        if (query.getParentNode() == null) {
            query.setOrigin(this.createCallOrigin());
        }
        return new OrmQueryRequest<T>(this, this.queryEngine, query, (SpiTransaction)transaction);
    }

    @Nullable
    private <T> T findIdCheckPersistenceContextAndCache(@Nullable Transaction transaction, SpiQuery<T> query, Object id) {
        PersistenceContext.WithOption o;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t == null) {
            t = this.currentServerTransaction();
        }
        BeanDescriptor<T> desc = query.getBeanDescriptor();
        id = desc.convertId(id);
        SpiPersistenceContext pc = null;
        if (t != null && this.useTransactionPersistenceContext(query) && (pc = t.getPersistenceContext()) != null && (o = desc.contextGetWithOption(pc, id)) != null) {
            if (o.isDeleted()) {
                return null;
            }
            return (T)o.getBean();
        }
        if (!query.isBeanCacheGet() || t != null && t.isSkipCache()) {
            return null;
        }
        return desc.cacheBeanGet(id, query.isReadOnly(), pc);
    }

    private <T> boolean useTransactionPersistenceContext(SpiQuery<T> query) {
        return PersistenceContextScope.TRANSACTION == this.persistenceContextScope(query);
    }

    @Override
    public PersistenceContextScope persistenceContextScope(SpiQuery<?> query) {
        PersistenceContextScope scope = query.getPersistenceContextScope();
        return scope != null ? scope : this.defaultPersistenceContextScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T findId(Query<T> query, @Nullable Transaction transaction) {
        T bean;
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(SpiQuery.Type.BEAN);
        if (SpiQuery.Mode.NORMAL == spiQuery.getMode() && !spiQuery.isForceHitDatabase() && (bean = this.findIdCheckPersistenceContextAndCache(transaction, spiQuery, spiQuery.getId())) != null) {
            return bean;
        }
        SpiOrmQueryRequest<T> request = this.buildQueryRequest(spiQuery, transaction);
        request.prepareQuery();
        if (request.isUseDocStore()) {
            return (T)this.docStore().find(request);
        }
        try {
            request.initTransIfRequired();
            Object object = request.findId();
            return (T)object;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public <T> Optional<T> findOneOrEmpty(Query<T> query, Transaction transaction) {
        return Optional.ofNullable(this.findOne(query, transaction));
    }

    @Nullable
    public <T> T findOne(Query<T> query, @Nullable Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query;
        if (spiQuery.isFindById()) {
            return this.findId(query, transaction);
        }
        if (transaction == null) {
            transaction = this.currentServerTransaction();
        }
        List<T> list = this.findList(query, transaction, true);
        return this.extractUnique(list);
    }

    @Nullable
    private <T> T extractUnique(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException("Unique expecting 0 or 1 results but got [" + list.size() + "]");
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<T> findSet(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.SET, query, transaction);
        Object result = request.getFromQueryCache();
        if (result != null) {
            return (Set)result;
        }
        try {
            request.initTransIfRequired();
            Set<T> set = request.findSet();
            return set;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, T> Map<K, T> findMap(Query<T> query, @Nullable Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.MAP, query, transaction);
        request.resetBeanCacheAutoMode(false);
        if ((transaction == null || !transaction.isSkipCache()) && request.getFromBeanCache()) {
            return request.beanCacheHitsAsMap();
        }
        Object result = request.getFromQueryCache();
        if (result != null) {
            return (Map)result;
        }
        try {
            request.initTransIfRequired();
            Map map = request.findMap();
            return map;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, T> List<A> findSingleAttributeList(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ATTRIBUTE, query, transaction);
        Object result = request.getFromQueryCache();
        if (result != null) {
            return (List)result;
        }
        try {
            request.initTransIfRequired();
            List list = request.findSingleAttributeList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public <T> int findCount(Query<T> query, @Nullable Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query;
        if (!spiQuery.isDistinct()) {
            spiQuery = spiQuery.copy();
        }
        return this.findCountWithCopy(spiQuery, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int findCountWithCopy(Query<T> query, @Nullable Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.COUNT, query, transaction);
        Integer result = (Integer)request.getFromQueryCache();
        if (result != null) {
            return result;
        }
        try {
            request.initTransIfRequired();
            int n = request.findCount();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public boolean exists(Class<?> beanType, Object beanId, Transaction transaction) {
        return !this.findIdsWithCopy(this.find(beanType).setId(beanId), transaction).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean exists(Query<T> ormQuery, Transaction transaction) {
        Query ormQueryCopy = ormQuery.copy().setMaxRows(1);
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.EXISTS, ormQueryCopy, transaction);
        List ids = (List)request.getFromQueryCache();
        if (ids != null) {
            return !ids.isEmpty();
        }
        try {
            request.initTransIfRequired();
            boolean bl = !request.findIds().isEmpty();
            return bl;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public <A, T> List<A> findIds(Query<T> query, Transaction transaction) {
        return this.findIdsWithCopy(((SpiQuery)query).copy(), transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A, T> List<A> findIdsWithCopy(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ID_LIST, query, transaction);
        Object result = request.getFromQueryCache();
        if (result != null) {
            if (Boolean.FALSE.equals(request.query().isReadOnly())) {
                return new CopyOnFirstWriteList((List)result);
            }
            return (List)result;
        }
        try {
            request.initTransIfRequired();
            List list = request.findIds();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int delete(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.DELETE, query, transaction);
        try {
            request.initTransIfRequired();
            request.markNotQueryOnly();
            if (request.isDeleteByStatement()) {
                int n = request.delete();
                return n;
            }
            List<Object> ids = request.findIds();
            if (ids.isEmpty()) {
                int n = 0;
                return n;
            }
            int n = this.persister.deleteByIds(request.descriptor(), ids, request.transaction(), false);
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.UPDATE, query, transaction);
        try {
            request.initTransIfRequired();
            request.markNotQueryOnly();
            int n = request.update();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public <T> FutureRowCount<T> findFutureCount(Query<T> query, Transaction transaction) {
        Query copy = ((SpiQuery)query).copy();
        copy.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        QueryFutureRowCount queryFuture = new QueryFutureRowCount(new CallableQueryCount(this, copy, newTxn));
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    public <T> FutureIds<T> findFutureIds(Query<T> query, Transaction transaction) {
        Query copy = ((SpiQuery)query).copy();
        copy.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        QueryFutureIds queryFuture = new QueryFutureIds(new CallableQueryIds(this, copy, newTxn));
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    public <T> FutureList<T> findFutureList(Query<T> query, Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query.copy();
        spiQuery.setFutureFetch(true);
        spiQuery.setPersistenceContext(new DefaultPersistenceContext());
        if (!spiQuery.isDisableReadAudit()) {
            BeanDescriptor desc = this.descriptorManager.descriptor(spiQuery.getBeanType());
            desc.readAuditFutureList(spiQuery);
        }
        Transaction newTxn = this.createTransaction();
        QueryFutureList queryFuture = new QueryFutureList(new CallableQueryList(this, spiQuery, newTxn));
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    public <T> PagedList<T> findPagedList(Query<T> query, Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query;
        int maxRows = spiQuery.getMaxRows();
        if (maxRows == 0) {
            throw new PersistenceException("maxRows must be specified for findPagedList() query");
        }
        if (spiQuery.isUseDocStore()) {
            return this.docStore().findPagedList(this.createQueryRequest(SpiQuery.Type.LIST, query, transaction));
        }
        return new LimitOffsetPagedList(this, spiQuery);
    }

    public <T> QueryIterator<T> findIterate(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, transaction);
        try {
            request.initTransIfRequired();
            return request.findIterate();
        }
        catch (RuntimeException ex) {
            request.endTransIfRequired();
            throw ex;
        }
    }

    public <T> Stream<T> findStream(Query<T> query, Transaction transaction) {
        return this.toStream(this.findIterate(query, transaction));
    }

    private <T> Stream<T> toStream(QueryIterator<T> queryIterator) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(queryIterator, 16), false).onClose(() -> queryIterator.close());
    }

    public <T> void findEach(Query<T> query, Consumer<T> consumer, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, transaction);
        if (request.isUseDocStore()) {
            this.docStore().findEach(request, consumer);
            return;
        }
        request.initTransIfRequired();
        request.findEach(consumer);
    }

    public <T> void findEach(Query<T> query, int batch, Consumer<List<T>> consumer, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, transaction);
        request.initTransIfRequired();
        request.findEach(batch, consumer);
    }

    public <T> void findEachWhile(Query<T> query, Predicate<T> consumer, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, transaction);
        if (request.isUseDocStore()) {
            this.docStore().findEachWhile(request, consumer);
            return;
        }
        request.initTransIfRequired();
        request.findEachWhile(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Version<T>> findVersions(Query<T> query, @Nullable Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, transaction);
        try {
            request.initTransIfRequired();
            List<Version<T>> list = request.findVersions();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public <T> List<T> findList(Query<T> query, Transaction transaction) {
        return this.findList(query, transaction, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> findList(Query<T> query, @Nullable Transaction transaction, boolean findOne) {
        SpiOrmQueryRequest<T> request = this.buildQueryRequest(SpiQuery.Type.LIST, query, transaction);
        request.resetBeanCacheAutoMode(findOne);
        if ((transaction == null || !transaction.isSkipCache()) && request.getFromBeanCache()) {
            return request.beanCacheHits();
        }
        request.prepareQuery();
        Object result = request.getFromQueryCache();
        if (result != null) {
            return (List)result;
        }
        if (request.isUseDocStore()) {
            return this.docStore().findList(request);
        }
        try {
            request.initTransIfRequired();
            List<T> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Nullable
    public SqlRow findOne(SqlQuery query, Transaction transaction) {
        List<SqlRow> list = this.findList(query, transaction);
        return this.extractUnique(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findEach(SqlQuery query, Consumer<SqlRow> consumer, Transaction transaction) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, transaction);
        try {
            request.initTransIfRequired();
            request.findEach(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findEachWhile(SqlQuery query, Predicate<SqlRow> consumer, Transaction transaction) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, transaction);
        try {
            request.initTransIfRequired();
            request.findEachWhile(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SqlRow> findList(SqlQuery query, Transaction transaction) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, transaction);
        try {
            request.initTransIfRequired();
            List<SqlRow> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> P executeSqlQuery(Function<RelationalQueryRequest, P> fun, SpiSqlQuery query) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, null);
        try {
            request.initTransIfRequired();
            P p = fun.apply(request);
            return p;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public void findEachRow(SpiSqlQuery query, RowConsumer consumer) {
        this.executeSqlQuery(req -> req.findEachRow(consumer), query);
    }

    @Override
    public <T> List<T> findListMapper(SpiSqlQuery query, RowMapper<T> mapper) {
        return this.executeSqlQuery(req -> req.findListMapper(mapper), query);
    }

    @Override
    public <T> T findOneMapper(SpiSqlQuery query, RowMapper<T> mapper) {
        return (T)this.executeSqlQuery(req -> req.findOneMapper(mapper), query);
    }

    @Override
    public <T> void findSingleAttributeEach(SpiSqlQuery query, Class<T> cls, Consumer<T> consumer) {
        this.executeSqlQuery(req -> req.findSingleAttributeEach(cls, consumer), query);
    }

    @Override
    public <T> List<T> findSingleAttributeList(SpiSqlQuery query, Class<T> cls) {
        return this.executeSqlQuery(req -> req.findSingleAttributeList(cls), query);
    }

    @Override
    public <T> T findSingleAttribute(SpiSqlQuery query, Class<T> cls) {
        return (T)this.executeSqlQuery(req -> req.findSingleAttribute(cls), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void findDtoEach(SpiDtoQuery<T> query, Consumer<T> consumer) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            request.findEach(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void findDtoEach(SpiDtoQuery<T> query, int batch, Consumer<List<T>> consumer) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            request.findEach(batch, consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void findDtoEachWhile(SpiDtoQuery<T> query, Predicate<T> consumer) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            request.findEachWhile(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> QueryIterator<T> findDtoIterate(SpiDtoQuery<T> query) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            return request.findIterate();
        }
        catch (RuntimeException ex) {
            request.endTransIfRequired();
            throw ex;
        }
    }

    @Override
    public <T> Stream<T> findDtoStream(SpiDtoQuery<T> query) {
        return this.toStream(this.findDtoIterate(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> findDtoList(SpiDtoQuery<T> query) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            List<T> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T findDtoOne(SpiDtoQuery<T> query) {
        DtoQueryRequest<T> request = new DtoQueryRequest<T>((SpiEbeanServer)this, this.dtoQueryEngine, query);
        try {
            request.initTransIfRequired();
            T t = this.extractUnique(request.findList());
            return t;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    public void save(Object bean) {
        this.save(bean, null);
    }

    public void save(Object bean, @Nullable Transaction transaction) {
        this.persister.save(this.checkEntityBean(bean), transaction);
    }

    public void markAsDirty(Object bean) {
        if (!(bean instanceof EntityBean)) {
            throw new IllegalArgumentException("This bean is not an EntityBean?");
        }
        ((EntityBean)bean)._ebean_getIntercept().setDirty(true);
    }

    public void update(Object bean) {
        this.update(bean, null);
    }

    public void update(Object bean, @Nullable Transaction transaction) {
        this.persister.update(this.checkEntityBean(bean), transaction);
    }

    public void updateAll(Collection<?> beans) throws OptimisticLockException {
        this.updateAll(beans, null);
    }

    public void updateAll(@Nullable Collection<?> beans, @Nullable Transaction transaction) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        this.executeInTrans(txn -> {
            for (Object bean : beans) {
                this.update(this.checkEntityBean(bean), (Transaction)txn);
            }
            return 0;
        }, transaction);
    }

    public void insert(Object bean) {
        this.insert(bean, null);
    }

    public void insert(Object bean, @Nullable Transaction transaction) {
        this.persister.insert(this.checkEntityBean(bean), transaction);
    }

    public void insertAll(Collection<?> beans) {
        this.insertAll(beans, null);
    }

    public void insertAll(@Nullable Collection<?> beans, @Nullable Transaction transaction) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        this.executeInTrans(txn -> {
            for (Object bean : beans) {
                this.persister.insert(this.checkEntityBean(bean), (Transaction)txn);
            }
            return 0;
        }, transaction);
    }

    public <T> List<T> publish(Query<T> query, @Nullable Transaction transaction) {
        return this.executeInTrans(txn -> this.persister.publish(query, (Transaction)txn), transaction);
    }

    @Nullable
    public <T> T publish(Class<T> beanType, Object id) {
        return this.publish(beanType, id, null);
    }

    public <T> List<T> publish(Query<T> query) {
        return this.publish(query, null);
    }

    @Nullable
    public <T> T publish(Class<T> beanType, Object id, @Nullable Transaction transaction) {
        Query query = this.find(beanType).setId(id);
        List<T> liveBeans = this.publish(query, transaction);
        return liveBeans.size() == 1 ? (T)liveBeans.get(0) : null;
    }

    public <T> List<T> draftRestore(Query<T> query, @Nullable Transaction transaction) {
        return this.executeInTrans(txn -> this.persister.draftRestore(query, (Transaction)txn), transaction);
    }

    @Nullable
    public <T> T draftRestore(Class<T> beanType, Object id, @Nullable Transaction transaction) {
        Query query = this.find(beanType).setId(id);
        List<T> beans = this.draftRestore(query, transaction);
        return beans.size() == 1 ? (T)beans.get(0) : null;
    }

    @Nullable
    public <T> T draftRestore(Class<T> beanType, Object id) {
        return this.draftRestore(beanType, id, null);
    }

    public <T> List<T> draftRestore(Query<T> query) {
        return this.draftRestore(query, null);
    }

    private EntityBean checkEntityBean(Object bean) {
        return (EntityBean)Objects.requireNonNull(bean);
    }

    public int saveAll(Collection<?> beans, Transaction transaction) throws OptimisticLockException {
        return this.saveAllInternal(beans, transaction);
    }

    public int saveAll(Collection<?> beans) throws OptimisticLockException {
        return this.saveAllInternal(beans, null);
    }

    public int saveAll(Object ... beans) throws OptimisticLockException {
        return this.saveAllInternal(Arrays.asList(beans), null);
    }

    private int saveAllInternal(@Nullable Collection<?> beans, @Nullable Transaction transaction) {
        if (beans == null || beans.isEmpty()) {
            return 0;
        }
        return this.executeInTrans(txn -> {
            txn.checkBatchEscalationOnCollection();
            int saveCount = 0;
            for (Object bean : beans) {
                this.persister.save(this.checkEntityBean(bean), (Transaction)txn);
                ++saveCount;
            }
            txn.flushBatchOnCollection();
            return saveCount;
        }, transaction);
    }

    public int delete(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null);
    }

    public int delete(Class<?> beanType, Object id, @Nullable Transaction transaction) {
        return this.delete(beanType, id, transaction, false);
    }

    public int deletePermanent(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null, true);
    }

    public int deletePermanent(Class<?> beanType, Object id, @Nullable Transaction transaction) {
        return this.delete(beanType, id, transaction, true);
    }

    private int delete(Class<?> beanType, Object id, @Nullable Transaction transaction, boolean permanent) {
        return this.executeInTrans(txn -> this.persister.delete(beanType, id, (Transaction)txn, permanent), transaction);
    }

    public int deleteAll(Class<?> beanType, Collection<?> ids) {
        return this.deleteAll(beanType, ids, null);
    }

    public int deleteAll(Class<?> beanType, Collection<?> ids, @Nullable Transaction transaction) {
        return this.deleteAll(beanType, ids, transaction, false);
    }

    public int deleteAllPermanent(Class<?> beanType, Collection<?> ids) {
        return this.deleteAll(beanType, ids, null, true);
    }

    public int deleteAllPermanent(Class<?> beanType, Collection<?> ids, @Nullable Transaction transaction) {
        return this.deleteAll(beanType, ids, transaction, true);
    }

    private int deleteAll(Class<?> beanType, Collection<?> ids, @Nullable Transaction transaction, boolean permanent) {
        return this.executeInTrans(txn -> this.persister.deleteMany(beanType, ids, (Transaction)txn, permanent), transaction);
    }

    public boolean delete(Object bean) {
        return this.delete(bean, null);
    }

    public boolean delete(Object bean, @Nullable Transaction transaction) throws OptimisticLockException {
        return this.persister.delete(this.checkEntityBean(bean), transaction, false) != 0;
    }

    public boolean deletePermanent(Object bean) throws OptimisticLockException {
        return this.deletePermanent(bean, null);
    }

    public boolean deletePermanent(Object bean, @Nullable Transaction transaction) throws OptimisticLockException {
        return this.persister.delete(this.checkEntityBean(bean), transaction, true) != 0;
    }

    public int deleteAllPermanent(Collection<?> beans) {
        return this.deleteAllInternal(beans, null, true);
    }

    public int deleteAllPermanent(Collection<?> beans, @Nullable Transaction transaction) {
        return this.deleteAllInternal(beans, transaction, true);
    }

    public int deleteAll(Collection<?> beans) {
        return this.deleteAllInternal(beans, null, false);
    }

    public int deleteAll(Collection<?> beans, @Nullable Transaction transaction) {
        return this.deleteAllInternal(beans, transaction, false);
    }

    private int deleteAllInternal(@Nullable Collection<?> beans, @Nullable Transaction transaction, boolean permanent) {
        if (beans == null || beans.isEmpty()) {
            return 0;
        }
        return this.executeInTrans(txn -> {
            txn.checkBatchEscalationOnCollection();
            int deleteCount = 0;
            for (Object bean : beans) {
                this.persister.delete(this.checkEntityBean(bean), (Transaction)txn, permanent);
                ++deleteCount;
            }
            txn.flushBatchOnCollection();
            return deleteCount;
        }, transaction);
    }

    public int execute(CallableSql callSql, @Nullable Transaction transaction) {
        return this.persister.executeCallable(callSql, transaction);
    }

    public int execute(CallableSql callSql) {
        return this.execute(callSql, null);
    }

    public int execute(SqlUpdate updSql, @Nullable Transaction transaction) {
        return this.persister.executeSqlUpdate(updSql, transaction);
    }

    @Override
    public int executeNow(SpiSqlUpdate sqlUpdate) {
        return this.persister.executeSqlUpdateNow(sqlUpdate, null);
    }

    @Override
    public void addBatch(SpiSqlUpdate sqlUpdate, @Nullable SpiTransaction transaction) {
        this.persister.addBatch(sqlUpdate, transaction);
    }

    @Override
    public int[] executeBatch(SpiSqlUpdate sqlUpdate, @Nullable SpiTransaction transaction) {
        return this.persister.executeBatch(sqlUpdate, transaction);
    }

    public int execute(SqlUpdate updSql) {
        return this.execute(updSql, null);
    }

    public int execute(Update<?> update, @Nullable Transaction transaction) {
        return this.persister.executeOrmUpdate(update, transaction);
    }

    public int execute(Update<?> update) {
        return this.execute(update, null);
    }

    @Override
    public List<BeanDescriptor<?>> descriptors() {
        return this.descriptorManager.descriptorList();
    }

    @Override
    public SpiTransactionManager transactionManager() {
        return this.transactionManager;
    }

    public void register(BeanPersistController controller) {
        for (BeanDescriptor<?> desc : this.descriptorManager.descriptorList()) {
            desc.register(controller);
        }
    }

    public void deregister(BeanPersistController controller) {
        for (BeanDescriptor<?> desc : this.descriptorManager.descriptorList()) {
            desc.deregister(controller);
        }
    }

    @Override
    public boolean isSupportedType(Type genericType) {
        ParamTypeHelper.TypeInfo typeInfo = ParamTypeHelper.getTypeInfo(genericType);
        return typeInfo != null && this.descriptorManager.descriptor(typeInfo.getBeanType()) != null;
    }

    public Object beanId(Object bean, Object id) {
        EntityBean eb = this.checkEntityBean(bean);
        return this.desc(bean.getClass()).convertSetId(id, eb);
    }

    public Object beanId(Object bean) {
        EntityBean eb = this.checkEntityBean(bean);
        return this.desc(bean.getClass()).getId(eb);
    }

    private <T> BeanDescriptor<T> desc(Class<T> beanClass) {
        BeanDescriptor<T> desc = this.descriptorManager.descriptor(beanClass);
        if (desc == null) {
            throw new PersistenceException(beanClass.getName() + " is NOT an Entity Bean registered with this server?");
        }
        return desc;
    }

    @Override
    public <T> BeanDescriptor<T> descriptor(Class<T> beanClass) {
        return this.descriptorManager.descriptor(beanClass);
    }

    @Override
    public List<BeanDescriptor<?>> descriptors(String tableName) {
        return this.descriptorManager.descriptors(tableName);
    }

    public List<? extends BeanType<?>> beanTypes() {
        return this.descriptors();
    }

    public List<? extends BeanType<?>> beanTypes(String tableName) {
        return this.descriptorManager.beanTypes(tableName);
    }

    public BeanType<?> beanTypeForQueueId(String queueId) {
        return this.descriptorByQueueId(queueId);
    }

    @Override
    public BeanDescriptor<?> descriptorByQueueId(String queueId) {
        return this.descriptorManager.descriptorByQueueId(queueId);
    }

    public <T> BeanType<T> beanType(Class<T> beanType) {
        return this.descriptor(beanType);
    }

    @Override
    public BeanDescriptor<?> descriptorById(String beanClassName) {
        return this.descriptorManager.descriptorByClassName(beanClassName);
    }

    @Override
    public void remoteTransactionEvent(RemoteTransactionEvent event) {
        this.transactionManager.remoteTransactionEvent(event);
        this.processRemoteCacheEvent(event);
    }

    private void processRemoteCacheEvent(RemoteTransactionEvent event) {
        RemoteCacheEvent cacheEvent = event.getRemoteCacheEvent();
        if (cacheEvent != null) {
            if (cacheEvent.isClearAll()) {
                this.serverCacheManager.clearAllLocal();
            } else {
                List<String> caches = cacheEvent.getClearCaches();
                if (caches != null) {
                    for (String cache : caches) {
                        try {
                            this.serverCacheManager.clearLocal(Class.forName(cache));
                        }
                        catch (Exception e) {
                            log.error("Error clearing local cache for type " + cache, (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private <P> P executeInTrans(Function<SpiTransaction, P> fun, @Nullable Transaction transaction) {
        ObtainedTransaction wrap = this.initTransIfRequired(transaction);
        try {
            P result = fun.apply(wrap.transaction());
            wrap.commitIfCreated();
            P p = result;
            return p;
        }
        catch (RuntimeException e) {
            wrap.endIfCreated();
            throw e;
        }
        finally {
            wrap.clearIfCreated();
        }
    }

    ObtainedTransaction initTransIfRequired(@Nullable Transaction transaction) {
        if (transaction != null) {
            return new ObtainedTransaction((SpiTransaction)transaction);
        }
        SpiTransaction trans = this.transactionManager.active();
        if (trans != null) {
            return new ObtainedTransaction(trans);
        }
        trans = this.beginServerTransaction();
        return new ObtainedTransactionImplicit(trans, this);
    }

    @Override
    public void clearServerTransaction() {
        this.transactionManager.clearServerTransaction();
    }

    @Override
    public SpiTransaction beginServerTransaction() {
        return this.transactionManager.beginServerTransaction();
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId) {
        return this.transactionManager.createReadOnlyTransaction(tenantId);
    }

    @Override
    public CallOrigin createCallOrigin() {
        return this.callStackFactory.createCallOrigin();
    }

    public DocumentStore docStore() {
        return this.documentStore;
    }

    public JsonContext json() {
        return this.jsonContext;
    }

    @Override
    public SpiJsonContext jsonExtended() {
        return this.jsonContext;
    }

    @Override
    public void slowQueryCheck(long timeMicros, int rowCount, SpiQuery<?> query) {
        if (timeMicros > this.slowQueryMicros && this.slowQueryListener != null) {
            this.slowQueryListener.process(new SlowQueryEvent(query.getGeneratedSql(), timeMicros / 1000L, rowCount, query.getParentNode()));
        }
    }

    public Set<Property> checkUniqueness(Object bean) {
        return this.checkUniqueness(bean, null);
    }

    public Set<Property> checkUniqueness(Object bean, @Nullable Transaction transaction) {
        EntityBean entityBean = this.checkEntityBean(bean);
        BeanDescriptor<?> beanDesc = this.descriptor(entityBean.getClass());
        BeanProperty idProperty = beanDesc.idProperty();
        if (idProperty == null) {
            return Collections.emptySet();
        }
        Object id = idProperty.value(entityBean);
        if (entityBean._ebean_getIntercept().isNew() && id != null) {
            DefaultOrmQuery query = new DefaultOrmQuery(beanDesc, this, this.expressionFactory);
            query.setId(id);
            if (this.findCount(query, transaction) > 0) {
                return Collections.singleton(idProperty);
            }
        }
        for (BeanProperty[] props : beanDesc.uniqueProps()) {
            Set<Property> ret = this.checkUniqueness(entityBean, beanDesc, props, transaction);
            if (ret == null) continue;
            return ret;
        }
        return Collections.emptySet();
    }

    @Nullable
    private Set<Property> checkUniqueness(EntityBean entityBean, BeanDescriptor<?> beanDesc, BeanProperty[] props, @Nullable Transaction transaction) {
        BeanProperty idProperty = beanDesc.idProperty();
        DefaultOrmQuery query = new DefaultOrmQuery(beanDesc, this, this.expressionFactory);
        ExpressionList exprList = query.where();
        if (!entityBean._ebean_getIntercept().isNew()) {
            exprList.ne(idProperty.name(), idProperty.value(entityBean));
        }
        for (BeanProperty prop : props) {
            Object value = prop.value(entityBean);
            if (value == null) {
                return null;
            }
            exprList.eq(prop.name(), value);
        }
        if (this.findCount(query, transaction) > 0) {
            LinkedHashSet<Property> ret = new LinkedHashSet<Property>();
            Collections.addAll(ret, props);
            return ret;
        }
        return null;
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        visitor.visitStart();
        if (visitor.collectTransactionMetrics()) {
            this.transactionManager.visitMetrics(visitor);
        }
        if (visitor.collectL2Metrics()) {
            this.serverCacheManager.visitMetrics(visitor);
        }
        if (visitor.collectQueryMetrics()) {
            this.descriptorManager.visitMetrics(visitor);
            this.dtoBeanManager.visitMetrics(visitor);
            this.relationalQueryEngine.visitMetrics(visitor);
            this.persister.visitMetrics(visitor);
        }
        this.extraMetrics.visitMetrics(visitor);
        visitor.visitEnd();
    }

    @Override
    public SpiQueryBindCapture createQueryBindCapture(SpiQueryPlan plan) {
        return this.queryPlanManager.createBindCapture(plan);
    }

    List<MetaQueryPlan> queryPlanInit(QueryPlanInit initRequest) {
        if (initRequest.isAll()) {
            this.queryPlanManager.setDefaultThreshold(initRequest.thresholdMicros());
        }
        return this.descriptorManager.queryPlanInit(initRequest);
    }

    List<MetaQueryPlan> queryPlanCollectNow(QueryPlanRequest request) {
        return this.queryPlanManager.collect(request);
    }
}

