/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.entity;

import io.ebean.enhance.common.ClassBytesReader;
import io.ebean.enhance.common.InputStreamTransform;
import io.ebean.enhance.common.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassPathClassBytesReader
implements ClassBytesReader {
    private final URL[] urls;

    public ClassPathClassBytesReader(URL[] urls) {
        this.urls = urls == null ? new URL[]{} : urls;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getClassBytes(String className, ClassLoader classLoader) {
        try (URLClassLoader cl = new URLClassLoader(this.urls, classLoader);){
            byte[] byArray;
            block17: {
                String resource = className.replace('.', '/') + ".class";
                URL url = cl.getResource(resource);
                if (url == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                InputStream is = UrlHelper.openNoCache(url);
                try {
                    byArray = InputStreamTransform.readBytes(is);
                    if (is == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("IOException reading bytes for " + className, e);
                    }
                }
                is.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing URLClassLoader for " + className, e);
        }
    }
}

