/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.asm.ClassReader;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.ClassMetaCache;
import io.ebean.enhance.common.ClassMetaReaderVisitor;
import io.ebean.enhance.common.EnhanceContext;

public class ClassMetaReader {
    private final ClassMetaCache metaCache;
    private final EnhanceContext enhanceContext;

    public ClassMetaReader(EnhanceContext enhanceContext, ClassMetaCache metaCache) {
        this.enhanceContext = enhanceContext;
        this.metaCache = metaCache;
    }

    public ClassMeta get(boolean readMethodAnnotations, String name, ClassLoader classLoader) throws ClassNotFoundException {
        return this.getWithCache(readMethodAnnotations, name, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMeta getWithCache(boolean readMethodAnnotations, String name, ClassLoader classLoader) throws ClassNotFoundException {
        ClassMetaCache classMetaCache = this.metaCache;
        synchronized (classMetaCache) {
            ClassMeta meta = this.metaCache.get(name);
            if (meta == null && (meta = this.readFromResource(readMethodAnnotations, name, classLoader)) != null) {
                ClassMeta superMeta;
                if (meta.isCheckSuperClassForEntity() && (superMeta = this.getWithCache(readMethodAnnotations, meta.getSuperClassName(), classLoader)) != null && superMeta.isEntity()) {
                    meta.setSuperMeta(superMeta);
                }
                this.metaCache.put(name, meta);
            }
            return meta;
        }
    }

    private ClassMeta readFromResource(boolean readMethodAnnotations, String className, ClassLoader classLoader) throws ClassNotFoundException {
        byte[] classBytes = this.enhanceContext.getClassBytes(className, classLoader);
        if (classBytes == null) {
            if (this.enhanceContext.isLog(3)) {
                this.enhanceContext.log(null, "Could not read meta data for class [" + className + "].");
            }
            return null;
        }
        if (this.enhanceContext.isLog(5)) {
            this.enhanceContext.log(className, "read ClassMeta");
        }
        try {
            ClassReader cr = new ClassReader(classBytes);
            ClassMetaReaderVisitor ca = new ClassMetaReaderVisitor(readMethodAnnotations, this.enhanceContext);
            cr.accept(ca, 6);
            return ca.getClassMeta();
        }
        catch (IllegalArgumentException e) {
            ClassMeta classMeta = this.metaCache.getFallback(className);
            if (classMeta != null) {
                return classMeta;
            }
            throw new ClassNotFoundException("Error reading " + className + " bytes len:" + classBytes.length + " no fallback in " + this.metaCache.fallbackKeys());
        }
    }
}

