/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.filter.Filter;
import io.dropwizard.logging.DropwizardLayout;
import io.dropwizard.logging.LoggingUtil;
import io.dropwizard.logging.layout.DiscoverableLayoutFactory;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class BootstrapLogging {
    @GuardedBy(value="BOOTSTRAPPING_LOCK")
    private static boolean bootstrapped = false;
    private static final Lock BOOTSTRAPPING_LOCK = new ReentrantLock();

    private BootstrapLogging() {
    }

    public static void bootstrap() {
        BootstrapLogging.bootstrap(Level.WARN);
    }

    public static void bootstrap(Level level) {
        BootstrapLogging.bootstrap(level, DropwizardLayout::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrap(Level level, DiscoverableLayoutFactory<ILoggingEvent> layoutFactory) {
        LoggingUtil.hijackJDKLogging();
        BOOTSTRAPPING_LOCK.lock();
        try {
            if (bootstrapped) {
                return;
            }
            Logger root = LoggingUtil.getLoggerContext().getLogger("ROOT");
            root.detachAndStopAllAppenders();
            LayoutBase<ILoggingEvent> layout = layoutFactory.build(root.getLoggerContext(), TimeZone.getDefault());
            layout.start();
            ThresholdFilter filter = new ThresholdFilter();
            filter.setLevel(level.toString());
            filter.start();
            ConsoleAppender appender = new ConsoleAppender();
            appender.addFilter((Filter)filter);
            appender.setContext((Context)root.getLoggerContext());
            LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
            layoutEncoder.setLayout(layout);
            appender.setEncoder((Encoder)layoutEncoder);
            appender.start();
            root.addAppender((Appender)appender);
            bootstrapped = true;
        }
        finally {
            BOOTSTRAPPING_LOCK.unlock();
        }
    }
}

