/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import io.dropwizard.util.Throwables;
import java.io.EOFException;
import java.io.IOException;
import java.util.Optional;
import java.util.zip.ZipException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

class ZipExceptionHandlingGzipHandler
extends GzipHandler {
    ZipExceptionHandlingGzipHandler() {
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            super.handle(target, baseRequest, request, response);
        }
        catch (Exception ex) {
            Optional<BadMessageException> badMessageException = Throwables.findThrowableInChain(t -> t.getCause() == null && (t instanceof ZipException || t instanceof EOFException), (Throwable)ex).map(e -> new BadMessageException(400, e.getMessage(), e));
            if (badMessageException.isPresent()) {
                throw badMessageException.get();
            }
            throw ex;
        }
    }
}

