/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public interface CloseableIterable<T>
extends Iterable<T>,
Closeable {
    @Override
    public CloseableIterator<T> iterator();

    @Override
    default public void forEach(Consumer<? super T> consumer) {
        try (Iterator iterator = this.iterator();){
            iterator.forEachRemaining(consumer);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    default public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException("spliterator is not supported");
    }

    public static <T> CloseableIterable<T> inMemoryIterable(CloseableIterator<T> closeableIterator) {
        final ArrayList arrayList = new ArrayList();
        try (CloseableIterator<T> closeableIterator2 = closeableIterator;){
            while (closeableIterator2.hasNext()) {
                arrayList.add(closeableIterator2.next());
            }
        }
        catch (Exception exception) {
            if (exception instanceof KernelException) {
                throw (KernelException)exception;
            }
            throw new RuntimeException(exception);
        }
        return new CloseableIterable<T>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public CloseableIterator<T> iterator() {
                return Utils.toCloseableIterator(arrayList.iterator());
            }
        };
    }

    public static <T> CloseableIterable<T> emptyIterable() {
        final CloseableIterator closeableIterator = Utils.toCloseableIterator(Collections.emptyList().iterator());
        return new CloseableIterable<T>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public CloseableIterator<T> iterator() {
                return closeableIterator;
            }
        };
    }
}

