/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.Snapshot;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private AtomicReference<SnapshotHint> latestSnapshotHint = new AtomicReference();
    private final Path logPath;
    private final Path tablePath;
    private static final Logger logger = LoggerFactory.getLogger(SnapshotManager.class);

    public SnapshotManager(Path path, Path path2) {
        this.logPath = path;
        this.tablePath = path2;
    }

    public static void verifyDeltaVersions(List<Long> list, Optional<Long> optional, Optional<Long> optional2) {
        List list2;
        if (!list.isEmpty() && !(list2 = LongStream.rangeClosed(list.get(0), list.get(list.size() - 1)).boxed().collect(Collectors.toList())).equals(list)) {
            throw new IllegalStateException(String.format("Versions (%s) are not continuous", list));
        }
        optional.ifPresent(l -> Preconditions.checkArgument(!list.isEmpty() && Objects.equals(list.get(0), l), String.format("Did not get the first delta file version %s to compute Snapshot", l)));
        optional2.ifPresent(l -> Preconditions.checkArgument(!list.isEmpty() && Objects.equals(list.get(list.size() - 1), l), String.format("Did not get the last delta file version %s to compute Snapshot", l)));
    }

    public Snapshot buildLatestSnapshot(Engine engine) throws TableNotFoundException {
        return this.getSnapshotAtInit(engine);
    }

    public Snapshot getSnapshotAt(Engine engine, long l) throws TableNotFoundException {
        Optional<LogSegment> optional = this.getLogSegmentForVersion(engine, Optional.empty(), Optional.of(l));
        return optional.map(logSegment -> this.createSnapshot((LogSegment)logSegment, engine)).orElseThrow(() -> new TableNotFoundException(this.tablePath.toString()));
    }

    public Snapshot getSnapshotForTimestamp(Engine engine, long l) throws TableNotFoundException {
        long l2 = System.currentTimeMillis();
        long l3 = DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.logPath, l);
        logger.info("{}: Took {}ms to fetch version at timestamp {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, l});
        return this.getSnapshotAt(engine, l3);
    }

    public void checkpoint(Engine engine, long l) throws TableNotFoundException, IOException {
        Object object;
        Object object2;
        logger.info("{}: Starting checkpoint for version: {}", (Object)this.tablePath, (Object)l);
        SnapshotImpl snapshotImpl = (SnapshotImpl)this.getSnapshotAt(engine, l);
        TableFeatures.validateWriteSupportedTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), snapshotImpl.getSchema(engine), this.tablePath.toString());
        Path path = FileNames.checkpointFileSingular(this.logPath, l);
        long l2 = 0L;
        try {
            object2 = snapshotImpl.getCreateCheckpointIterator(engine);
            object = null;
            try {
                engine.getParquetHandler().writeParquetFileAtomically(path.toString(), (CloseableIterator<FilteredColumnarBatch>)object2);
                logger.info("{}: Checkpoint file is written for version: {}", (Object)this.tablePath, (Object)l);
                l2 = ((CreateCheckpointIterator)object2).getNumberOfAddActions();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((CreateCheckpointIterator)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((CreateCheckpointIterator)object2).close();
                    }
                }
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw new CheckpointAlreadyExistsException(l);
        }
        object2 = new CheckpointMetaData(l, l2, Optional.empty());
        object = new Checkpointer(this.logPath);
        ((Checkpointer)object).writeLastCheckpointFile(engine, (CheckpointMetaData)object2);
        logger.info("{}: Last checkpoint metadata file is written for version: {}", (Object)this.tablePath, (Object)l);
        logger.info("{}: Finished checkpoint for version: {}", (Object)this.tablePath, (Object)l);
    }

    private void registerHint(SnapshotHint snapshotHint) {
        this.latestSnapshotHint.updateAndGet(snapshotHint2 -> {
            if (snapshotHint2 == null) {
                return snapshotHint;
            }
            if (snapshotHint.getVersion() > snapshotHint2.getVersion()) {
                return snapshotHint;
            }
            return snapshotHint2;
        });
    }

    private CloseableIterator<FileStatus> listFrom(Engine engine, long l) throws IOException {
        logger.debug("{}: startVersion: {}", (Object)this.tablePath, (Object)l);
        return engine.getFileSystemClient().listFrom(FileNames.listingPrefix(this.logPath, l));
    }

    private boolean isDeltaCommitOrCheckpointFile(String string) {
        return FileNames.isCheckpointFile(string) || FileNames.isCommitFile(string);
    }

    private Optional<CloseableIterator<FileStatus>> listFromOrNone(Engine engine, long l) {
        try {
            CloseableIterator<FileStatus> closeableIterator = this.listFrom(engine, l);
            if (closeableIterator.hasNext()) {
                return Optional.of(closeableIterator);
            }
            return Optional.empty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.empty();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to list the files in delta log", iOException);
        }
    }

    protected final Optional<List<FileStatus>> listDeltaAndCheckpointFiles(Engine engine, long l, Optional<Long> optional) {
        optional.ifPresent(l2 -> Preconditions.checkArgument(l2 >= l, String.format("versionToLoad=%s provided is less than startVersion=%s", l2, l)));
        logger.debug("startVersion: {}, versionToLoad: {}", (Object)l, optional);
        return this.listFromOrNone(engine, l).map(closeableIterator -> {
            ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
            while (closeableIterator.hasNext()) {
                FileStatus fileStatus = (FileStatus)closeableIterator.next();
                if (!this.isDeltaCommitOrCheckpointFile(Path.getName(fileStatus.getPath())) || FileNames.isCheckpointFile(Path.getName(fileStatus.getPath())) && fileStatus.getSize() == 0L) continue;
                boolean bl = optional.map(l -> FileNames.getFileVersion(new Path(fileStatus.getPath())) <= l).orElse(true);
                if (!bl) {
                    if (!arrayList.isEmpty()) break;
                    long l2 = DeltaHistoryManager.getEarliestRecreatableCommit(engine, this.logPath);
                    throw DeltaErrors.versionBeforeFirstAvailableCommit(this.tablePath.toString(), (Long)optional.get(), l2);
                }
                arrayList.add(fileStatus);
            }
            return arrayList;
        });
    }

    private SnapshotImpl getSnapshotAtInit(Engine engine) throws TableNotFoundException {
        Checkpointer checkpointer = new Checkpointer(this.logPath);
        Optional<CheckpointMetaData> optional = checkpointer.readLastCheckpointFile(engine);
        if (!optional.isPresent()) {
            logger.warn("{}: Last checkpoint file is missing or corrupted. Will search for the checkpoint files directly.", (Object)this.tablePath);
        }
        Optional<LogSegment> optional2 = this.getLogSegmentFrom(engine, optional);
        return optional2.map(logSegment -> this.createSnapshot((LogSegment)logSegment, engine)).orElseThrow(() -> new TableNotFoundException(this.tablePath.toString()));
    }

    private SnapshotImpl createSnapshot(LogSegment logSegment, Engine engine) {
        String string = logSegment.checkpointVersionOpt.map(l -> String.format("starting from checkpoint version %s.", l)).orElse(".");
        logger.info("{}: Loading version {} {}", new Object[]{this.tablePath, logSegment.version, string});
        LogReplay logReplay = new LogReplay(this.logPath, this.tablePath, logSegment.version, engine, logSegment, Optional.ofNullable(this.latestSnapshotHint.get()));
        long l2 = System.currentTimeMillis();
        LogReplayUtils.assertLogFilesBelongToTable(this.logPath, logSegment.allLogFilesUnsorted());
        SnapshotImpl snapshotImpl = new SnapshotImpl(this.tablePath, logSegment, logReplay, logReplay.getProtocol(), logReplay.getMetadata());
        logger.info("{}: Took {}ms to construct the snapshot (loading protocol and metadata) for {} {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, logSegment.version, string});
        SnapshotHint snapshotHint = new SnapshotHint(snapshotImpl.getVersion(engine), snapshotImpl.getProtocol(), snapshotImpl.getMetadata());
        this.registerHint(snapshotHint);
        return snapshotImpl;
    }

    private Optional<LogSegment> getLogSegmentFrom(Engine engine, Optional<CheckpointMetaData> optional) {
        return this.getLogSegmentForVersion(engine, optional.map(checkpointMetaData -> checkpointMetaData.version), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<LogSegment> getLogSegmentForVersion(Engine engine, Optional<Long> optional, Optional<Long> optional2) {
        long l2;
        long l3;
        Optional<Long> optional3 = optional.filter(l -> !optional2.isPresent() || l <= (Long)optional2.get());
        if (!optional3.isPresent() && optional2.isPresent()) {
            l3 = optional2.get() + 1L;
            l2 = System.currentTimeMillis();
            optional3 = Checkpointer.findLastCompleteCheckpointBefore(engine, this.logPath, l3).map(checkpointInstance -> checkpointInstance.version);
            logger.info("{}: Took {}ms to load last checkpoint before version {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, l3});
        }
        l3 = optional3.orElseGet(() -> {
            logger.warn("{}: Starting checkpoint is missing. Listing from version as 0", (Object)this.tablePath);
            return 0L;
        });
        l2 = System.currentTimeMillis();
        Optional<List<FileStatus>> optional4 = this.listDeltaAndCheckpointFiles(engine, l3, optional2);
        logger.info("{}: Took {}ms to list the files after starting checkpoint", (Object)this.tablePath, (Object)(System.currentTimeMillis() - l2));
        l2 = System.currentTimeMillis();
        try {
            Optional<LogSegment> optional5 = this.getLogSegmentForVersion(engine, optional3, optional2, optional4);
            return optional5;
        }
        finally {
            logger.info("{}: Took {}ms to construct a log segment", (Object)this.tablePath, (Object)(System.currentTimeMillis() - l2));
        }
    }

    protected Optional<LogSegment> getLogSegmentForVersion(Engine engine, Optional<Long> optional, Optional<Long> optional2, Optional<List<FileStatus>> optional3) {
        long l;
        List<FileStatus> list;
        if (optional3.isPresent()) {
            list = optional3.get();
        } else {
            if (!optional.isPresent()) {
                return Optional.empty();
            }
            list = Collections.emptyList();
        }
        this.logDebug(() -> String.format("newFiles: %s", Arrays.toString(list.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        if (list.isEmpty() && !optional.isPresent()) {
            throw new RuntimeException(String.format("No delta files found in the directory: %s", this.logPath));
        }
        if (list.isEmpty()) {
            return this.getLogSegmentForVersion(engine, Optional.empty(), optional2);
        }
        Tuple2<List<FileStatus>, List<FileStatus>> tuple2 = ListUtils.partition(list, fileStatus -> FileNames.isCheckpointFile(new Path(fileStatus.getPath()).getName()));
        List list2 = (List)tuple2._1;
        List list3 = (List)tuple2._2;
        this.logDebug(() -> String.format("\ncheckpoints: %s\ndeltas: %s", Arrays.toString(list2.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray()), Arrays.toString(list3.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        CheckpointInstance checkpointInstance2 = optional2.map(CheckpointInstance::new).orElse(CheckpointInstance.MAX_VALUE);
        logger.debug("lastCheckpoint: {}", (Object)checkpointInstance2);
        List<CheckpointInstance> list4 = list2.stream().map(fileStatus -> new CheckpointInstance(fileStatus.getPath())).collect(Collectors.toList());
        this.logDebug(() -> String.format("checkpointFiles: %s", Arrays.toString(list4.toArray())));
        Optional<CheckpointInstance> optional4 = Checkpointer.getLatestCompleteCheckpointFromList(list4, checkpointInstance2);
        logger.debug("newCheckpointOpt: {}", optional4);
        long l3 = optional4.map(checkpointInstance -> checkpointInstance.version).orElseGet(() -> {
            optional.map(l -> {
                long l2 = optional2.orElseGet(() -> {
                    FileStatus fileStatus = (FileStatus)list3.get(list3.size() - 1);
                    return FileNames.deltaVersion(new Path(fileStatus.getPath()));
                });
                return this.getLogSegmentWithMaxExclusiveCheckpointVersion(l2, (long)l).orElseThrow(() -> new RuntimeException(String.format("Checkpoint file to load version: %s is missing.", l)));
            });
            return -1L;
        });
        logger.debug("newCheckpointVersion: {}", (Object)l3);
        List<FileStatus> list5 = list3.stream().filter(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath())) > l3).collect(Collectors.toList());
        this.logDebug(() -> String.format("deltasAfterCheckpoint: %s", Arrays.toString(list5.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        LinkedList linkedList = list5.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toCollection(LinkedList::new));
        this.logDebug(() -> String.format("deltaVersions: %s", Arrays.toString(linkedList.toArray())));
        long l4 = l = linkedList.isEmpty() ? optional4.get().version : (Long)linkedList.getLast();
        if (list3.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any delta files for version %s", l));
        }
        optional2.filter(l2 -> l2 != l).ifPresent(l2 -> {
            throw DeltaErrors.versionAfterLatestCommit(this.tablePath.toString(), l2, l);
        });
        if (!linkedList.isEmpty()) {
            if ((Long)linkedList.getFirst() != l3 + 1L) {
                throw new RuntimeException(String.format("Log file not found.\nExpected: %s\nFound: %s", FileNames.deltaFile(this.logPath, l3 + 1L), FileNames.deltaFile(this.logPath, (Long)linkedList.get(0))));
            }
            SnapshotManager.verifyDeltaVersions(linkedList, Optional.of(l3 + 1L), optional2);
        }
        long l5 = ((FileStatus)list3.get(list3.size() - 1)).getModificationTime();
        List<FileStatus> list6 = optional4.map(checkpointInstance -> {
            HashSet<Path> hashSet = new HashSet<Path>(checkpointInstance.getCorrespondingFiles(this.logPath));
            List list2 = list2.stream().filter(fileStatus -> hashSet.contains(new Path(fileStatus.getPath()))).collect(Collectors.toList());
            if (list2.size() != hashSet.size()) {
                String string = String.format("Seems like the checkpoint is corrupted. Failed in getting the file information for:\n%s\namong\n%s", hashSet.stream().map(Path::toString).collect(Collectors.toList()), list2.stream().map(FileStatus::getPath).collect(Collectors.joining("\n - ")));
                throw new IllegalStateException(string);
            }
            return list2;
        }).orElse(Collections.emptyList());
        return Optional.of(new LogSegment(this.logPath, l, list5, list6, optional4.map(checkpointInstance -> checkpointInstance.version), l5));
    }

    private Optional<LogSegment> getLogSegmentWithMaxExclusiveCheckpointVersion(long l, long l2) {
        return Optional.empty();
    }

    private void logDebug(Supplier<String> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(supplier.get());
        }
    }
}

