/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.utils.FileStatus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LogSegment {
    public final Path logPath;
    public final long version;
    public final List<FileStatus> deltas;
    public final List<FileStatus> checkpoints;
    public final Optional<Long> checkpointVersionOpt;
    public final long lastCommitTimestamp;
    private final Lazy<List<FileStatus>> allFiles;
    private final Lazy<List<FileStatus>> allFilesReversed;

    public static LogSegment empty(Path path) {
        return new LogSegment(path, -1L, Collections.emptyList(), Collections.emptyList(), Optional.empty(), -1L);
    }

    public LogSegment(Path path, long l, List<FileStatus> list, List<FileStatus> list2, Optional<Long> optional, long l2) {
        this.logPath = path;
        this.version = l;
        this.deltas = list;
        this.checkpoints = list2;
        this.checkpointVersionOpt = optional;
        this.lastCommitTimestamp = l2;
        this.allFiles = new Lazy<List>(() -> Stream.concat(list2.stream(), list.stream()).collect(Collectors.toList()));
        this.allFilesReversed = new Lazy<List>(() -> this.allFiles.get().stream().sorted(Comparator.comparing(fileStatus -> new Path(fileStatus.getPath()).getName()).reversed()).collect(Collectors.toList()));
    }

    public List<FileStatus> allLogFilesUnsorted() {
        return this.allFiles.get();
    }

    public List<FileStatus> allLogFilesReversed() {
        return this.allFilesReversed.get();
    }
}

